import os
import sys

mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)

from rr_python_utils.load_rrdata import rrData


def get_client_groups():
    config_dir = rrData.getRRFolder_cfgUser()
    if not config_dir:
        print("ERROR: RR folder not found.")
        return

    grp_config_file = config_dir + "clientgroups.ini"

    group_list = rrData._ClientGroupList()
    cfg_loaded = group_list.loadFromFile(grp_config_file)

    if not cfg_loaded:
        print("ERROR: Unable to load file '{0}'. {1}".format(grp_config_file, group_list.getError()))
        return

    print("List of groups loaded ({0} groups)".format(group_list.count))

    return group_list


if __name__ == "__main__":
    group_list = get_client_groups()
    if group_list:
        for grp_idx in range(group_list.count):
            grp = group_list.clientGroup(grp_idx)
            print("    " + grp.getName())
