#include "rrSceneParserShake.h"

#include <QFile> 
#include <QTextStream>
#include "../../shared_SDK/RR_DataTypes_jobs0__Classes_SDK.h"


DllExport_plugin int pInfo(rrP::_dataPARS_Info * const data)
{
	data->RRVersion= rrVersion;
	data->QTVersion= qVersion();
    data->MinorID=rrP::MinorID_PARS;

    //Human readable informations about the plugin:
    data->pluginName=       "Shake";
    data->pluginAuthor=     "RR, Holger Schoenberger";
    data->pluginVersion=    "1.0";

    //Check if the data structure is compatible:
    if (data->StructureID!=rrP::StructureID_PARS) {
        data->StructureID=rrP::StructureID_PARS;
        return rrP::rRRDataVersionConflict;
    } else {
        data->StructureID=rrP::StructureID_PARS;
    }

	data->setDebugCompile();
	data->supportedFileExt= "*.shk;";

	return rrP::rSuccessful;
}




DllExport_plugin int pLoadSceneFile(rrP::_dataPARS_LoadSceneFile * const data)
{
	try 
	{
	//check for version conflict RRender<>This plugin:
	if (!data->jobs->isVersionSupported()) return rrP::rRRDataVersionConflict; 
	QFile scnFile(*(data->fileName));
	if (!scnFile.open(QIODevice::ReadOnly | QIODevice::Text)) {
		return rrP::rFileFailedToOpen;
	}
	QTextStream fStreamIn(&scnFile);
	QString line;

	int seqStart=1,seqEnd=100,seqStep=1;
    rrJ::_JobBasics_largePath *job = NULL;
	int AppVersMayor=2;
	QString AppVersMinor;

	int lineNo=0;
	while (!fStreamIn.atEnd()) {
		lineNo++;
		line=fStreamIn.readLine().trimmed();
		if (line.isEmpty()) continue;
		if ((lineNo<3) && (line.contains("Shake v",Qt::CaseInsensitive))) {
			line.remove(0,line.indexOf("Shake v",0,Qt::CaseInsensitive)+7);
			AppVersMayor=line.left(line.indexOf('.')).toInt();
			line.remove(0,line.indexOf('.')+1);
			if (line.indexOf('.')<line.indexOf(' ')) 
				 AppVersMinor=line.left(line.indexOf('.'));
			else AppVersMinor=line.left(line.indexOf(' '));
			continue;
		}
		if (line.startsWith("//")) continue;
		if (line.contains("SetTimeRange",Qt::CaseInsensitive)) {
			line.remove(0,line.indexOf('"')+1);
			line.truncate(line.indexOf('"'));
			if (line.isEmpty()) continue;
			if (line.contains('-',Qt::CaseInsensitive)) {
				seqStart=line.left(line.indexOf('-')).toInt();
				line.remove(0,line.indexOf('-')+1);
				if (!line.contains('x',Qt::CaseInsensitive)) {
					seqEnd=line.left(line.indexOf('x')).toInt();
					line.remove(0,line.indexOf('x')+1);
					seqStep=line.toInt();
				} else {
					seqEnd=line.toInt();
					seqStep=1;
				}
			} else {
				seqStart=line.toInt();
				seqEnd=seqStart;
				seqStep=1;
			}
			continue;
		}
		if (line.contains("FileOut(",Qt::CaseInsensitive)) { //Ignore Ifcheck
			if (line.endsWith(',')) line+=fStreamIn.readLine().trimmed();
			if (!data->jobs->getNewJob(job)) return rrP::rMemError;
			job->m_layer=line.left(line.indexOf('=')).trimmed();
			line.remove(0,line.indexOf('=')+1);
			line.remove(0,line.indexOf('"')+1);
			line.truncate(line.indexOf('"'));
			if (line.contains('#')) {
				job->m_imageFileName=line.left(line.indexOf('#'));
				line.remove(0,line.indexOf('#'));
				job->m_imageFramePadding=0;
				while ((!line.isEmpty()) && (line.at(0)=='#')) {
					job->m_imageFramePadding++;
					line.remove(0,1);
				}
				job->m_imageExtension=line;
			} else if (line.contains('@')) {
				job->m_imageFileName=line.left(line.indexOf('@'));
				line.remove(0,line.indexOf('@'));
				job->m_imageFramePadding=0;
				while ((!line.isEmpty()) && (line.at(0)=='@')) {
					job->m_imageFramePadding++;
					line.remove(0,1);
				}
				job->m_imageExtension=line;
			} else {
				job->m_imageFileName=line;
			}
			/*if (job->ImageFileName.value[1]=='/') {
				QString st;
				st=job->ImageFileName;
				st.remove(0,3);
				st.remove(0,st.indexOf('/')+1);
#ifdef RR_OS_WIN
				if (st.indexOf('/')==1) {
					st.insert(1,':');
				}
#endif
				job->ImageFileName=st;
			}
			*/
			continue;
		}
	}

	scnFile.close();
	QString DatabaseDir;
	DatabaseDir=*(data->fileName);
	if (DatabaseDir.contains(PD)) {
		DatabaseDir.truncate(DatabaseDir.lastIndexOf(PD)+1);
	}


	if (data->jobs->m_maxJobs>0) {
        rrJ::_JobBasics_largePath *jobCopy = NULL;
		if (!data->jobs->getNewJob(jobCopy)) return rrP::rMemError;
		job= data->jobs->at(0);
		if (!job) return rrP::rMemError;
		*jobCopy=*job;
		job->m_layer=rrLayerAll;
		job->m_uiIsChecked=true;
	}


	for (int j=0; j<data->jobs->m_maxJobs;j++) {
		job= data->jobs->at(j);
		if (!job) return rrP::rMemError;
		job->m_soft.name="Shake";
		job->m_seqStart=seqStart;
		job->m_seqEnd=seqEnd;
		job->m_seqStep=seqStep;
		job->m_soft.version=AppVersMayor;
		job->m_soft.setVersionMinor(AppVersMinor);
		job->m_sceneName=*(data->fileName);
		job->m_sceneDatabaseDir=DatabaseDir;
		
		job->splitImageFileInto_DirFileExt(true);
	}

	return rrP::rSuccessful;
	}
	catch (...)
	{
		return rrP::rCError;

	}
}


