#include "rrSceneParserVRay.h"

#include <QFile> 
#include <QTextStream>
#include "../../shared_SDK/RR_DataTypes_jobs0__Classes_SDK.h"


DllExport_plugin int pInfo(rrP::_dataPARS_Info * const data)
{
	data->RRVersion= rrVersion;
	data->QTVersion= qVersion();
    data->MinorID=rrP::MinorID_PARS;

    //Human readable informations about the plugin:
    data->pluginName=       "VRay_StdA";
    data->pluginAuthor=     "RR, Holger Schoenberger";
    data->pluginVersion=    "1.0";

    //Check if the data structure is compatible:
    if (data->StructureID!=rrP::StructureID_PARS) {
        data->StructureID=rrP::StructureID_PARS;
        return rrP::rRRDataVersionConflict;
    } else {
        data->StructureID=rrP::StructureID_PARS;
    }

	data->setDebugCompile();
	data->supportedFileExt= "*.vrscene;";

	return rrP::rSuccessful;
}




DllExport_plugin int pLoadSceneFile(rrP::_dataPARS_LoadSceneFile * const data)
{
	try 
	{
	//check for version conflict RRender<>This plugin:
	if (!data->jobs->isVersionSupported()) return rrP::rRRDataVersionConflict; 


	QFile scnFile(*(data->fileName));
	if (!scnFile.open(QIODevice::ReadOnly | QIODevice::Text)) {
		return rrP::rFileFailedToOpen;
	}
	QTextStream fStreamIn(&scnFile);
	QString line;

    rrJ::_JobBasics_largePath *job = NULL;
	if (!data->jobs->getNewJob(job)) return rrP::rMemError;

	
	job->m_sceneName=*(data->fileName);
	QString DatabaseDir;
	DatabaseDir=*(data->fileName);
	if (DatabaseDir.contains(PD)) {
		DatabaseDir.truncate(DatabaseDir.lastIndexOf(PD)+1);
	}
	if (DatabaseDir.contains("Render_Archives")) {
		DatabaseDir.truncate(DatabaseDir.lastIndexOf("Render_Archives"));
	}
	job->m_sceneDatabaseDir=DatabaseDir;
	job->m_layer=rrLayerDefault;
	job->m_camera=rrLayerDefault;

    qint64 startFrame=1;
    qint64 endFrame=1;
    int step=1;
    bool framesSet=false;
	bool foundFileName=false;


	//QString fileext;
	//filetype jpeg
	int lineNo=0;
	while (!fStreamIn.atEnd()) {
		lineNo++;
		line=fStreamIn.readLine().trimmed();
		if (line.isEmpty()) continue;

		if (line.startsWith("// Frame at time")) { //IGNORE IFCHECK
            line.remove(0,16);
            qint64 frNr= line.toInt();
            if (framesSet) {
                if (startFrame>frNr) startFrame=frNr;
                if (endFrame<frNr) {
                    if (frNr-endFrame>step) step=frNr-endFrame;
                    endFrame=frNr;
                }
                framesSet=true;
            } else {
                framesSet=true;
                startFrame=frNr;
                endFrame=frNr;
            }
		} if (line.startsWith("// V-Ray core version is")) { //IGNORE IFCHECK
			line.remove(0,line.indexOf(" is")+3);
			line=line.trimmed();
			line.truncate(line.indexOf(' '));

			if (line.contains('.',Qt::CaseInsensitive)) {
				job->m_soft.version=line.left(line.indexOf('.')).toInt();
				line.remove(0,line.indexOf('.')+1);
                if (line.contains('.',Qt::CaseInsensitive)) {
                    line=line.left(line.indexOf('.'));
                }
				job->m_soft.setVersionMinor(line);
			} else {
				job->m_soft.version=line.toInt();
			}
        } if (line.startsWith("img_width=")) { //IGNORE IFCHECK
			line.remove(0,line.indexOf('=')+1);
			line.truncate(line.indexOf(';'));
			job->m_imageWidth=line.toInt();
		} else if (line.startsWith("img_height=")) {//IGNORE IFCHECK
			line.remove(0,line.indexOf('=')+1);
			line.truncate(line.indexOf(';'));
			job->m_imageHeight=line.toInt();
		} else if (line.startsWith("img_file=")) {//IGNORE IFCHECK
			line.remove(0,line.indexOf('"')+1);
			line.truncate(line.indexOf('"'));
			job->m_imageFileName=line;
			foundFileName=true;
		} else if (line.startsWith("img_dir=")) {//IGNORE IFCHECK
			line.remove(0,line.indexOf('"')+1);
			line.truncate(line.indexOf('"'));
			job->m_imageDir=line;
		}
	}
	scnFile.close();

	if (job->m_imageFileName.isEmpty()) {
		if (foundFileName) return rrP::rNoImageOutput;
		return rrP::rFileFailedToOpen;
	}
	

    job->m_soft.name="VRay_StdA";
    if (startFrame==endFrame) {
		job->m_soft.rendererName="multifile";
        job->m_seqStart=1;
        job->m_seqEnd=1;
    } else {
        job->m_seqStart=startFrame;
        job->m_seqEnd=endFrame;
        job->m_seqStep=step;
    }

	job->m_uiIsChecked=true;
	job->splitImageFileInto_DirFileExt();

	return rrP::rSuccessful;
	}
	catch (...)
	{
		return rrP::rCError;

	}
}


