import sys, os


class RoyalFTPrevParser(object):
    def __init__(self, *args):
        self._path_size = 3
        self._debug = False
        
        self._path_list = [''] * self._path_size
        self.ftid = None
        self.user = None

        self.parse(args)
        self.error = ""
        self.success = self._is_valid()
    
    def _is_valid(self):
        if self._debug:
            print("ftID", self.ftid)
            print("User", self.user)
            print("paths", self._path_list)

        if not self.ftid:
            self.error = "Missing argument: -ftID (FTrack ID)"
            return False
        if not self.user:
            self.error = "Missing argument: -user"
            return False
        for path in self._path_list:
            if not path:
                self.error = "Missing argument: -p1, -p2, -p3 (preview paths)"
                return False

        return True

    def parse(self, args):
        args = list(args)
        if not args:
            raise Exception("no arguments given: -ftID FTRACK_ID -p1 PATH_1 -p2... -user USER")

        while args:
            arg = args.pop(0)
            if arg == "-debug":
                self._debug = True
                continue

            if args and arg == "-ftID":
                self.ftid = args.pop(0)
                continue
            
            if args and arg.startswith("-p") and len(arg) == 3 and arg[-1].isdigit():
                path_idx = int(arg[-1]) - 1
                if path_idx < self._path_size:
                    self._path_list[path_idx] = args.pop(0)
                continue

            if args and arg == "-user":
                self.user = args.pop(0)

    @property
    def p1(self):
        return self._path_list[0]
    
    @property
    def p2(self):
        return self._path_list[1]
    
    @property
    def p3(self):
        return self._path_list[2]


class RRftParseException(Exception):
    pass


def do_it():
    parser = RoyalFTPrevParser(*sys.argv)
    if not parser.success:
        raise RRftParseException(parser.error)

    ftID = parser.ftid
    if ((len(ftID)<=1) or (ftID=="none")):
        print("Job has no ftrack ID.")
        return

    print("Adding preview images to ftrack")

    import royalFTrack
    from royalFTrack import rrJob

    oRRFT = royalFTrack.royalFTrack()
    oRRFT.session_setup(parser.user)

    oRenderjob = rrJob.from_ftrack_id(ftID)
    if oRenderjob:
        if not os.path.exists(parser.p1):
            print("preview image %s doesnt exist" % parser.p1)
            return
        if not os.path.exists(parser.p2):
            print("preview image %s doesnt exist" % parser.p2)
            return
        if not os.path.exists(parser.p3):
            print("preview image %s doesnt exist" % parser.p3)
            return

        oRenderjob.ft_rr_components_create(lPreviewFilePaths=[parser.p1, parser.p2, parser.p3])


do_it()
