# -*- coding: cp1252 -*-
#
# Information for the plugin loader
# rrPluginName: Arnold DeNoice job parser
# rrPluginAuthor:	Paolo Acampora - Binary Alchemy
# rrPluginVersion:	0.2
# rrPluginType:		Scene Parser Plugin
# rrRRversion:		%rrVersion%
#
#
#
# This setting is important for scene parser job plugins and need to be set:
# rrSupportedFileExt: *.exr;
#
#
#
# Copyright (c) [Binary Alchemy]
######################################################################

import os


def getFramePadding(file_name):
    """Return job frame padding extracted from full filename"""
    file_padding = 0
    while file_name[-1].isdigit():
        file_padding += 1
        file_name = file_name[:-1]

    return file_padding


def getRenderApp():
    """Return Arnold Denoice RenderApp"""
    renderApp = rrJob._RenderAppBasic()
    renderApp.clear()
    renderApp.name = "Arnold"
    renderApp.rendererName = "DeNoice"
    renderApp.type = "Comp"

    return renderApp


def getNoiceJob(frame_padding, input_image, image_ext):
    """Return a new Noice job based on input parameters"""
    newJob =  rr.getNewJob()
    newJob.imageFramePadding = frame_padding
    newJob.imageFileName = os.path.join("<SceneFolder>", "denoised",
                                        "<SceneName>" + "_denoised_" + "#" * frame_padding + image_ext)
    newJob.imageSingleOutputFile =False
    newJob.splitImageFileInto_DirFileExt(False)
    newJob.uiIsChecked = True

    newJob.renderApp = getRenderApp()
    newJob.sceneName = input_image

    return newJob


def addNoiceJob():
    input_image = rr.sceneFileToLoad()
    file_name, file_ext = os.path.splitext(input_image)
    frame_padding = getFramePadding(file_name)

    newJob = getNoiceJob(frame_padding, input_image, file_ext)

    rr.jobAll_set(999,newJob)  #If the index of the job is larger than the number of jobs,a new job is added to the end of the job list. So I used 999.
    rr.returnFromPlugin(rrGlobal.pluginReturn.successful)


if __name__ == "__main__":
    # Ask the user if Arnold DeNoice is the desired job. Leave it to the next plugin if it isn't
    msgRet = rrGlobal.messageBox(rrGlobal.logLvL.info,
                                 "EXR file selected:\n\nCreate Arnold DeNoice job?", "Yes", "No, use next plugin", False, 30)

    if msgRet == 0:  # 0: Button 2 ("No") was clicked, 1: Button 1 was clicked
        rr.returnFromPlugin(rrGlobal.pluginReturn.unsupportedFormat)
        raise rrCleanExit()
    else:
        addNoiceJob()
