# -*- coding: cp1252 -*-
#
# These lines are just information lines for the plugin loader
# rrPluginName:		Autopano Video scene reader
# rrPluginAuthor:	Holger Schoenberger
# rrPluginVersion:	%rrVersion%
# rrPluginType:		Scene Parser Plugin
# rrRRversion:		8.0
#
#
#
# This setting is important for scene parser job plugins and need to be set.
# 
# rrSupportedFileExt: *.kava;
#
#
#
# Copyright (c) Holger Schoenberger - Binary Alchemy
######################################################################
import os
import xml.etree.ElementTree

sceneFile= rr.sceneFileToLoad();
try:
    sceneXml = xml.etree.ElementTree.parse(sceneFile).getroot()
except Exception as e:
    rrGlobal.writeLog(rrGlobal.logLvL.progress, "Error loading file: "+str(e),"") #progress messages will only be shown in the small log window of the rrSubmitter, but do not show a dialog window. As we do not want two dialog windows, see next line
    rr.returnFromPlugin(rrGlobal.pluginReturn.fileFailedToOpen)  # this shows a general message window
    raise rrCleanExit() #I am using rrCleanExit because I do not want any traceback info
   
try:    
    panoVersionNode = sceneXml.find(".//pano/version")
    panoVersion=panoVersionNode.attrib["application"]
    panoVersion = ''.join([i for i in panoVersion if (i.isdigit() or i=='.')])
    
    timelineNode= sceneXml.find(".//timeLine")
    seqStart=int(timelineNode.attrib["start"])
    seqEnd=int(timelineNode.attrib["end"])
    
    outputNode= sceneXml.find(".//output")
    outputFile=outputNode.attrib["file"]
    if len(outputFile)<2:
        rr.returnFromPlugin(rrGlobal.pluginReturn.noImageOutput)  # this shows a general message window
        raise rrCleanExit() #I am using rrCleanExit because I do not want any traceback info
    isRelativePath= outputFile.startswith(".")  or  ((outputFile[0]!="/") and  (outputFile[1]!=":") )
    if (isRelativePath):
        outputFile="<SceneFolder>"+outputFile
except Exception as e:
    rrGlobal.writeLog(rrGlobal.logLvL.progress, "Error parsing file: "+str(e),"") #progress messages will only be shown in the small log window of the rrSubmitter, but do not show a dialog window. As we do not want two dialog windows, see next line
    rr.returnFromPlugin(rrGlobal.pluginReturn.dataError)  # this shows a general message window
    raise rrCleanExit() #I am using rrCleanExit because I do not want any traceback info
   
   
#Create a job
renderApp= rrJob._RenderAppBasic()
renderApp.clear()
renderApp.name="Autopano Video"
renderApp.setVersionBoth(panoVersion)


newJob=  rr.getNewJob()
newJob.sceneName=sceneFile
newJob.renderApp=renderApp
newJob.imageFileName=outputFile
newJob.imageSingleOutputFile=True
newJob.splitImageFileInto_DirFileExt(False)
newJob.uiIsChecked= True
newJob.seqStart=seqStart
newJob.seqEnd=seqEnd


rr.jobAll_set(999,newJob)  #If the index of the job is larger than the number of jobs,a new job is added to the end of the job list. So I used 999.

rr.returnFromPlugin(rrGlobal.pluginReturn.successful)