#
#################################################################
#
#   PLEASE USE rrSubmitter menu Scripted Jobs/Create Weekly Stats to create a .csv file with this script once a week.
#   You might want to set the "Start After" value of the job to Sunday evening.
#
#################################################################
#
#
# Reads the server daily stat files for the latest X days
# and saves a .csv file with line for each project
#
# You need to execute this python script with rrPythonconsole
#
# Syntax:
#     rrPythonconsole Stats_exportLastDaysTables.py NUM_DAYS EXPORT_FOLDER
#
# default values are -1 for NUM_DAYS and RR_ROOT/inhouse as export folder
#
# NUM_DAYS = -1 collects stats from all the dailystats that are found
# EXPORT_FOLDER must NOT end with "/"
#

import struct
import datetime

import os
import sys


mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)

from rr_python_utils.load_rrdata import rrData



# Arguments

try:
    num_days = int(sys.argv[1])
except IndexError:
    num_days = 5
except ValueError:
    num_days = 5
    
try:
    exportFolder = sys.argv[2]
except IndexError:
    exportFolder = rrGlobal.rrRootPath() + "inhouse"
if (exportFolder[0] == "-"):
    exportFolder = rrGlobal.rrRootPath() + "inhouse"
exportFolder+= "/"

# rrTable for storing projects stats
rrTableProjects = rrGlobal._rrTable()
rrTableProjects.setHeader(0, "Project")
rrTableProjects.setHeader(1, "Average FrameTime in sec.")
rrTableProjects.setHeader(2, "Average Memory Usage")
rrTableProjects.setHeader(3, "Average PS Usage")
rrTableProjects.setHeader(4, "Frames Rendered")
rrTableProjects.setHeader(5, "Max FrameTime in sec")
rrTableProjects.setHeader(6, "Max Memory Usage in MB")
rrTableProjects.setHeader(7, "Max PSUsage")
rrTableProjects.setHeader(8, "Times Frame Segment Finished")
rrTableProjects.setHeader(9, "Times Frame Segment Sent")


serverDaily = rrData._dailyStats_data()
serverStatFolder = rrData.getRRFolder_cfgStats()+ "server/"
serverStatFileList = sorted(  # list of .sdb, starting from most recent
    [f for f in os.listdir(serverStatFolder) if os.path.isfile(os.path.join(serverStatFolder, f))],
    reverse=True
)

if num_days > 0:
    serverStatFileList = serverStatFileList[:num_days]

print("{0}: {1} files being processed".format(serverStatFolder, len(serverStatFileList)))

# dictionaries of total occurrences to average, per row
avFrTime_total = {}
avMemUse_total = {}
avPSUse_total = {}

for i, statFile in enumerate(serverStatFileList):
    if not serverDaily.loadFromFile(serverStatFolder + statFile, True):
        print(statFile+"| Error:  unable to load stats file! " + serverDaily.getError())
    else:
        prjStat = serverDaily.singleStats(1)  # list of projects stats
        print(statFile+ " loaded, "+str(len(prjStat)) + " projects")
        for stats in prjStat:
            # load previous values
            row = rrTableProjects.rowIndex(stats.name, True)
            rrTableProjects.setString(0, row, stats.name)

            avFrameTime = max(rrTableProjects.cellAsFloat(1, row), 0.0)
            avMemUsageMB = max(rrTableProjects.cellAsFloat(2, row), 0.0)
            avPSUsage = max(rrTableProjects.cellAsFloat(3, row), 0.0)

            framesRendered = max(rrTableProjects.cellAsInt(4, row), 0)

            maxFrameTime = max(rrTableProjects.cellAsInt(5, row), 0)
            maxMemUsageMB = max(rrTableProjects.cellAsInt(6, row), 0)
            maxPSUsage = max(rrTableProjects.cellAsFloat(7, row), 0)

            timesFinished = max(rrTableProjects.cellAsInt(8, row), 0)
            timesSended = max(rrTableProjects.cellAsInt(9, row), 0)

            for t in range(0, stats.statCount()):
                stat = stats.stats(t)  # stat for the t-th part of the day (each 15 mins)
                if not stat.hasValidData():
                    continue
                framesRendered += stat.framesRendered
                timesFinished += stat.timesFinished
                timesSended += stat.timesSended

                maxFrameTime = max(maxFrameTime, stat.maxFrameTime)
                maxMemUsageMB = max(maxMemUsageMB, stat.maxMemUsageMB)
                maxPSUsage = max(maxPSUsage, stat.maxPSUsage)

                if stat.avFrameTime:
                    if (stat.avMemUsageMB==0 and (stat.jobsRendering>0)):
                        #workaround for old bug that has set wrong avFrameTime (and avMemUsageMB)
                        avFrameTime += stat.avFrameTime / stat.jobsRendering * (stat.jobsWaiting + stat.jobsDisabled + stat.jobsIdle + stat.jobsRendering + stat.jobsDone)
                    else:
                        avFrameTime += stat.avFrameTime
                    try:
                        avFrTime_total[row] += 1
                    except KeyError:
                        avFrTime_total[row] = 1
                if stat.avMemUsageMB:
                    avMemUsageMB += stat.avMemUsageMB
                    try:
                        avMemUse_total[row] += 1
                    except KeyError:
                        avMemUse_total[row] = 1
                if stat.avPSUsage:
                    avPSUsage += stat.avPSUsage
                    try:
                        avPSUse_total[row] += 1
                    except KeyError:
                        avPSUse_total[row] = 1

            # store current values
            rrTableProjects.setFloat(1, row, avFrameTime)
            rrTableProjects.setFloat(2, row, avMemUsageMB)
            rrTableProjects.setFloat(3, row, avPSUsage)

            rrTableProjects.setInt(4, row, framesRendered)

            rrTableProjects.setInt(5, row, maxFrameTime)
            rrTableProjects.setInt(6, row, maxMemUsageMB)
            rrTableProjects.setFloat(7, row, maxPSUsage)

            rrTableProjects.setInt(8, row, timesFinished)
            rrTableProjects.setInt(9, row, timesSended)



# average values
for row, total in avFrTime_total.items():
    avSum = float(rrTableProjects.cellAsFloat(1, row))
    if (total>0):
        rrTableProjects.setInt(1, row, int(avSum / total))
for row, total in avMemUse_total.items():
    avSum = float(rrTableProjects.cellAsFloat(2, row))
    if (total>0):
        rrTableProjects.setInt(2, row, int(avSum / total))
for row, total in avPSUse_total.items():
    print (row, total)
    avSum = float(rrTableProjects.cellAsFloat(3, row))
    if (total>0):
        rrTableProjects.setInt(3, row, int(avSum / total))

   
    
out_csv = "{0}stats_{1}_{2}d.csv".format(exportFolder, datetime.date.today().strftime('%Y%m%d'),num_days)
if not rrTableProjects.saveAsCsv(out_csv, False):
    print ("Error: Unable to save project table to file '"+out_csv+"'! "+rrTableProjects.fileError())

print("Saved into folder " + exportFolder)
print("\n\n--- DONE ---\n\n")
