import sys
import os
import logging

mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)

from rr_python_utils.load_rrlib import rrLib  # module libpyRR3 for python 3, libpyRR2 for python 2
import rr_python_utils.connection as rr_connect



def get_logger():
    return logging.getLogger("rrPy")


def get_machine_hostname():
    import socket
    return socket.gethostname()


def disable_client(client_name=None):
    tcp = rr_connect.server_connect()

    logger = get_logger()
    
    if not client_name:
        client_name = get_machine_hostname()
        logger.info("\n\n\t             client: " + client_name)

    logger.info("Checking clients")
    if not tcp.clientGetList():
        logger.error("No clients listed: " + tcp.errorMessage())
        return

    clients = tcp.clients
    clients_count = clients.count()

    logger.info("Found {0} clients".format(clients_count))

    client_apply_list = []

    if sys.version_info.major < 3:
        RANGE_FUNC = xrange
    else:
        RANGE_FUNC = range

    for i in RANGE_FUNC(clients_count):
        client = clients.at(i)
        logger.info("\tCpuUsage {0:6.2f} name: {1}".format(client.status.CPU_Usage, client.name))
        if client.name().lower() == client_name.lower():
            client_apply_list.append(i)

    if not client_apply_list:
        print("No clients named '{0}', no action taken".format(client_name))
        return
    print("Clients in list: '{0}'".format(client_apply_list))

    success = tcp.clientSendCommand(client_apply_list, rrLib._ClientCommand.cDisable, "")
    if not success:
        logger.error("Command not sent: " + tcp.errorMessage())


disable_client()
print("\n\n--- DONE ---\n\n")
