#
# This script shows the usage of the libpyRR (rrLib) module.
# - It connects to the rrServer
# - Displays all clients with status
# - Finds clients with Working Hours enabled
# - Sends an Ignore Working Hours command.
#
#

import sys
import os

mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)

from rr_python_utils.load_rrlib import rrLib  # module libpyRR3 for python 3, libpyRR2 for python 2
import rr_python_utils.connection as rr_connect
import rrJob



if sys.version_info.major < 3:
    RANGE_FUNC = xrange
else:
    RANGE_FUNC = range



def check_clients(tcp):
    print("\nCheck clients")
    if not tcp.clientGetList():
        print("Error getting clients: " + tcp.errorMessage())
        return

    clients = tcp.clients
    clients.sortBy(rrLib._clientColumns.Client)
    
    clients_count = clients.count()
    print("Number of clients found: " + str(clients_count))

    client_apply_list = []
    
    for c in RANGE_FUNC(clients_count):
        client = clients.at(c)
        clientStatus= client.status
        print("\t name: {}  - Job threads: {}  - Cores: {}".format(client.name(), clientStatus.maxJobThreads, client.hw.nrCores))
        for ct in RANGE_FUNC(clientStatus.maxJobThreads):
            jThread = client.jobThread(ct)
            print("\t\t jobThread #{} status:  {} ({})  ".format(ct, jThread.clientStatus, jThread.clientStatusAsStringSingle()))
            if (jThread.clientStatus==rrClient._ClientStatus.sDisabledWorkinghours) or (jThread.clientStatus==rrClient._ClientStatus.sDisabledWorkinghoursAllowLittle):
                client_apply_list.append(c)

    if not client_apply_list:
        return
    print("Clients in list: '{0}'".format(client_apply_list))

    success = tcp.clientSendCommand(client_apply_list, rrLib._ClientCommand.cIgnoreWorking, "")
    if not success:
        logger.error("Command cIgnoreWorking was not sent: " + tcp.errorMessage())
        



rrTcp = rr_connect.server_connect(user_name=None)
check_clients(rrTcp)

print("\n\nConnection Stats " + rrTcp.connectionStats())
print("\n\n--- DONE ---\n\n")
