
# A simple example script to get jobs based on the human readable Short ID "{85Ob}".

# Usage:
# %RR_ROOT%\bin\win64\rrPythonconsole  %RR_ROOT%\SDK\External\Python\Job_GetSingleJobByStrID.py -jidStr {85Ob}
# If you want to get all jobs of the same submission:
# %RR_ROOT%\bin\win64\rrPythonconsole  %RR_ROOT%\SDK\External\Python\Job_GetSingleJobByStrID.py -jidStr {85O
#
# Note that the human readable ID is short and not unique. If you have a lot of jobs (>10tsd), it might be that the {ID} exists twice
#

import sys
import os
import shutil


mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)

from rr_python_utils.load_rrlib import rrLib  # module libpyRR3 for python 3, libpyRR2 for python 2
import rr_python_utils.connection as rr_connect


def get_job_from_id(job_id_Str, user_name=None):
    tcp = rr_connect.server_connect()
    tcp.jobList_SetFilter4("", "", "", rrJob._renderType.stUnset, 0, job_id_Str, False, rrLib._filterIDs.isAll)

    if not tcp.jobList_GetInfo():
        print("Error getting jobs: " + tcp.errorMessage())
        return
    jobs = tcp.jobs
    jobs_count = jobs.getMaxJobsFiltered()
    print("Number of jobs - filtered by job_id_Str {0}: {1}".format(job_id_Str, jobs_count))
    for i in range(0, jobs_count):
        job_id = jobs.getJobMinInfo_filterQueue(i).ID
        job = jobs.getJobInfo(job_id)
        job_line = "\t{} \n\tscene: {} \n\timage dim: {}x{}  \n\tOutput: {}{}{}{} ".format(
            job.IDstr(), job.sceneName, job.imageWidth, job.imageHeight, job.imageDir, job.imageFileName, str("#" * job.imageFramePadding) 	, job.imageExtension
        )
        print(job_line)



if __name__ == "__main__":
    import argparse
    parser = argparse.ArgumentParser()
    parser.add_argument("-jidStr")
    args = parser.parse_args()

    job_data = get_job_from_id(args.jidStr)
