#
#  This script reads the server daily stat file for the average frame time
#  of each project, user and render app and saves them into an excel file
#
# You need to execute this python script with rrPythonconsole
#
import os
import sys


mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)

from rr_python_utils.load_rrdata import rrData

from os import listdir
from os.path import isfile, join
import csv


exportFolder = rrGlobal.rrRootPath() + "inhouse/"


#Note: Please check your license via rrControl/help menu of you have access to the class rrTable
rrTableInfo	= rrGlobal._rrTable();
rrTableInfo.setHeader(0, "Name")		
rrTableInfo.setHeader(1, "lastConnect")		
rrTableInfo.setHeader(2, "lastWOLTry")		
rrTableInfo.setHeader(3, "WOLTryCount")	
rrTableInfo.setHeader(4, "IP")		
rrTableInfo.setHeader(5, "IP-Date")		
rrTableInfo.setHeader(6, "IP")		
rrTableInfo.setHeader(7, "IP-Date")		
rrTableInfo.setHeader(8, "WOL success")		
rrTableInfo.setHeader(9, "WOL Date")		
rrTableInfo.setHeader(10, "WOL boot time")		
rrTableInfo.setHeader(11, "WOL success")		
rrTableInfo.setHeader(12, "WOL Date")		
rrTableInfo.setHeader(13, "WOL boot time")		
rrTableInfo.setHeader(14, "WOL success")		
rrTableInfo.setHeader(15, "WOL Date")		
rrTableInfo.setHeader(16, "WOL boot time")		


statFile = rrGlobal.rrRootPath() + "sub/stats/clientIPstats82.db"

serverInfo= rrData._server_clientInfo()
if not serverInfo.loadFromFile(statFile):
    raise Exception(serverInfo.errorStr() )

print ("File was was updated: ",serverInfo.fileTime())


row= 0
for cIdx in range(0,serverInfo.count()):
    row= row+1
    cInfo=serverInfo.info(cIdx)
    test= cInfo.saveNameCopy
    rrTableInfo.setString(0,row,cInfo.saveNameCopy)
    if cInfo.lastConnect.year>1970:
        rrTableInfo.setDatetime(1,row,cInfo.lastConnect)
    if cInfo.lastWOLTry.year>1970:
        rrTableInfo.setDatetime(2,row,cInfo.lastWOLTry)
    rrTableInfo.setInt(3,row,cInfo.WOLTryCount)
    
    col=4
    #we print the first 2 only 
    for iIdx in range(0,2):
        if cInfo.lastIPDate(iIdx).year>1970:
            idx=0
            rrTableInfo.setString(col,row,cInfo.lastIPs(iIdx).asString())
            col=col+1
            rrTableInfo.setDatetime(col,row,cInfo.lastIPDate(iIdx))
            col=col+1

    
    col=8
    #we print the first 3 only 
    for iIdx in range(0,3):
        idx=0
        if (cInfo.lastWOLs(0).success):
            rrTableInfo.setString(col,row,"true")
            col=col+1
            rrTableInfo.setDatetime(col,row,cInfo.lastWOLs(0).dateTime)
            col=col+1
            rrTableInfo.setInt(col,row,cInfo.lastWOLs(0).bootTime)
            col=col+1
        else:
            if cInfo.lastWOLs(0).dateTime.year>1970:
                rrTableInfo.setString(col,row,"FALSE")
                col=col+1
                rrTableInfo.setDatetime(col,row,cInfo.lastWOLs(0).dateTime)
                col=col+1
                col=col+1
     
    

	    
	    
if not rrTableInfo.saveAsCsv(exportFolder+"_Info_Client_WOL.csv", False):
    print ("Error: Unable to save user table! "+rrTableInfo.fileError())
	
	

print("Saved into folder "+exportFolder)
print("\n\n--- DONE ---\n\n")
