# This example file requires you to copy the files 
# \render_apps\_config_inhouse\examples\
# into its parent folder \render_apps\_config_inhouse\
#
# It is an example how you can submit custom rez commandlines if you do not want to use RRs commandlines with REZ
# There is a rez_houdini file which starts hython
# And a Rez_ExdecuteOnce file to start a custom commandline
# Of course you could start hython with an execute file, but there are app specific settings that are highly recommended to keep
# Most of the rrClient error detection requires these settings


scriptVersion_str="rez  1.0.12"
exportAsXML= False



import sys
import os
import shutil
import traceback
import tempfile
from datetime import datetime
import logging

# create logger
logger = logging.getLogger("rrSubmit")
logger.setLevel(logging.DEBUG)
ch = logging.StreamHandler()
ch.setLevel(logging.DEBUG)
# create formatter and add it to the handlers
formatter = logging.Formatter("%(asctime)s %(name)s| %(levelname)s:  %(message)s", "%H:%M:%S")
ch.setFormatter(formatter)
# add the handlers to the logger
logger.addHandler(ch)


    
mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)

from rr_python_utils.load_rrsubmit import rrSubmitLib  # module for python 3.7, 3.9 or 2.7
import rrJob


rrSubmitter= rrSubmitLib.Submitter()
rrSubmitter.deleteAllJobs()
renderApp= rrJob._RenderAppBasic() #somehow this does not work within Houdini?



#Example 1: create a Houdini job
renderApp.clear()
renderApp.name="rez_Houdini"
renderApp.setVersionBoth("19.0.12")
renderApp.rendererName=""  

newJob= rrSubmitLib.createEmptyJob2("//filesserver/share/Houdini/scene.hip", scriptVersion_str)
newJob.renderApp= renderApp
newJob.layer= "/out/mantra1"
newJob.imageFileName= "C:/Houdini/rendeOut/myRender.###.exr"
newJob.seqStart= 1
newJob.seqEnd=  100

newJob.preID=0

envList= ""
envList= envList + "MyEnv=MyValue"  + "~~~"
envList= envList + "MoreEnv=MoreValue"  + "~~~"
newJob.customDataAppend_Str("rrEnvList", envList )

newJob.customSet_Str("RezPacks", "Houdini_19  PluginX")

newJob.customSet_Str("AddCmdFlags", " //fileserver/share/Pipeline/myHythonscript.py <SeqStart> <SeqEnd>")

logger.debug("Add Job:  {}   {} start:{} end:{}".format(newJob.renderApp.rendererName,  newJob.layer, newJob.seqStart,  newJob.seqEnd))
rrSubmitter.addJob(newJob)



#Example 2: create an commandline job that waits for the first job
renderApp.clear()
renderApp.name="rez_Execute"
renderApp.rendererName="Once"  

newJob= rrSubmitLib.createEmptyJob2("//filesserver/share/Houdini/anyExistingFile", scriptVersion_str) #workaround to use the rrClient function that verifies that it has access to the project share with files
newJob.renderApp= renderApp

newJob.waitForPreID_set(0, 0) #old version takes the waitForID index 0-29 and the preID of the other job 0-250 
#newJob.waitForPreID_add(0)  #new version requires RR version 8.3.10. It automatically increases the waitForID index

newJob.customSet_Str("AddCmdFlags", "myCommand myFlag myFlag myFlag myFlag ")

newJob.customSet_Str("RezPacks", "Houdini_19  PluginX")

logger.debug("Adding Job:  {}-{}   ".format(renderApp.name, newJob.renderApp.rendererName))
rrSubmitter.addJob(newJob)



    
if (exportAsXML):
    now = datetime.now() 
    xmlFilename= os.path.join(tempfile.gettempdir(), "rrPythonScript"+ "_"+ now.strftime("%m%d%H%M%S") +".xml")
    
    rrJob.exportJobAsXml_MultiStart()
    for jNr in range(0, rrSubmitter.getJobCount()):
        job= rrSubmitter.getJob(jNr)
        rrJob.exportJobAsXml_MultiAdd(job, False)
    if not rrJob.exportJobAsXml_MultiEnd(xmlFilename, False, False):
        logger.error("Unable to export as xml file "+xmlFilename)
    else:
        logger.info("Exported as xml file "+xmlFilename)

else:
    if (not rrSubmitter.submitJobs()):
        logger.error("Unable to submit jobs!")
    else:
        rrJobIDs_All_Str=""
        rrJobID_LIST= []
        rrJobIDStr_LIST= []
        for jNr in range(0, rrSubmitter.getJobCount()):
            rrJobID_LIST.append(rrSubmitter.jobsSendID(jNr))
            rrJobIDStr_LIST.append(rrJob.jID2Str(rrJobID_LIST[jNr]))
            rrJobIDs_All_Str= rrJobIDs_All_Str + rrJob.jID2Str(rrJobID_LIST[jNr]) + ", "
        logger.info("Submited {} jobs: {}".format(len(rrJobID_LIST),rrJobIDs_All_Str ))




