
# Note: This script was written for Windows
# In case someone has shut down the RR autostart service or it froze, this script connects to the machines and restarts the service.
# If the machine is offline, the windows service connect app "sc" takes ages to recognize this.
# Therefore we use a ping first, which has a way smaller timeout.


def addPingCondition(text_file, clientName, command):
    text_file.write("echo __________________________________ " + clientName+" __________________________________\n")
    text_file.write("ping -n 1 " + clientName+"\n")
    text_file.write("if %ERRORLEVEL% == 0 (\n")
    text_file.write("  "+command+"\n")
    text_file.write(")\n")



text_file = open("C:\\temp\\offline_clients.bat", "w")
text_file.write("echo off\n")
text_file.write(" \n")
text_file.write(" \n")

nrClients= rr.clientAll_count()


for i in range(0,rr.clientAll_count()):
    client=rr.clientAll_get(i)
    if (client.isSelected() and client.jobThread(0).clientStatus==0):
        addPingCondition(text_file, client.name(), "sc \\\\"+client.name()+" stop RoyalRenderService")


text_file.write(" \n")
text_file.write(" \n")
text_file.write(" \n")
text_file.write("echo Shutting down the service might take a few seconds.\n")
text_file.write("echo Please continue if this script was started more than 10 seconds ago.\n")
text_file.write("pause \n")
text_file.write(" \n")
text_file.write(" \n")
text_file.write(" \n")

        
for i in range(0,rr.clientAll_count()):
    client=rr.clientAll_get(i)
    if (client.isSelected() and client.jobThread(0).clientStatus==0):
        addPingCondition(text_file, client.name(), "sc \\\\"+client.name()+" start RoyalRenderService")


text_file.write(" \n")
text_file.write(" \n")
text_file.write(" \n")
text_file.write("pause \n")
        
text_file.close()





