import sys, os


class RoyalFTPrevParser(object):
    def __init__(self, *args):
        self._debug = False
        
        self.ftid = None
        self.user = None
        self.mov = None

        self.parse(args)
        self.error = ""
        self.success = self._is_valid()
    
    def _is_valid(self):
        if self._debug:
            print("ftID", self.ftid)
            print("User", self.user)
            print("mov", self.mov)

        if not self.ftid:
            self.error = "Missing argument: -ftID (FTrack ID)"
            return False
        if not self.user:
            self.error = "Missing argument: -user"
            return False
        if not self.mov:
            self.error = "Missing argument: -mov (Path to .mov file)"
            return False

        return True

    def parse(self, args):
        args = list(args)
        if not args:
            raise Exception("no arguments given: -ftID FTRACK_ID -mov PATH_TO_MOV -user USER")

        while args:
            arg = args.pop(0)
            if arg == "-debug":
                self._debug = True
                continue

            if args and arg == "-ftID":
                self.ftid = args.pop(0)
                continue

            if args and arg == "-mov":
                self.mov = args.pop(0)

            if args and arg == "-user":
                self.user = args.pop(0)


class RRftParseException(Exception):
    pass


def do_it():
    parser = RoyalFTPrevParser(*sys.argv)
    if not parser.success:
        raise RRftParseException(parser.error)

    ftID = parser.ftid
    if ((len(ftID)<=1) or (ftID=="none")):
        print("Job has no ftrack ID.")
        return

    print("Adding quicktime to ftrack")

    import royalFTrack
    from royalFTrack import rrJob

    oRRFT = royalFTrack.royalFTrack()
    oRRFT.session_setup(parser.user)

    oRenderjob = rrJob.from_ftrack_id(ftID)
    if oRenderjob:
        if not os.path.exists(parser.mov):
            print("quicktime %s doesnt exist" % parser.mov)
            return

        oRenderjob.ft_rr_components_create(sQuicktime=parser.mov)


do_it()
