import sys, os


class RoyalFTStatParser(object):
    def __init__(self, *args):
        self._debug = False

        self.ftid = None
        self.user = None
        self.status = None
        self.av_mem_usage = None
        self.av_render_time = None

        self.parse(args)
        self.error = ""
        self.success = self._is_valid()
    
    def _is_valid(self):
        if self._debug:
            print("ftid", self.ftid)
            print("avMemUsage", self.av_mem_usage)
            print("avRenderTime", self.av_render_time)
            print("status", self.status)
            print("user", self.user)

        if not self.ftid:
            self.error = "Missing argument: -ftID (FTrack ID)"
            return False
        if not self.user:
            self.error = "Missing argument: -user"
            return False       
        if not self.status:
            self.error = "Missing argument: -status (Render Entity State)"
            return False
        if not self.av_mem_usage:
            self.error = "Missing argument: -avMemUsage (Average Memory Usage)"
            return False
        if not self.av_render_time:
            self.error = "Missing argument: -avRenderTime (Average Render Time)"
            return False

        return True

    def parse(self, args):
        args = list(args)
        if not args:
            raise Exception("no arguments given: -ftID FTRACK_ID -user USER -status RENDER_STATUS -avMemUsage AV_MEM_USAGE -avRenderTime AV_RENDER_TIME")

        while args:
            arg = args.pop(0)
            if arg == "-debug":
                self._debug = True
                continue

            if args and arg == "-ftID":
                self.ftid = args.pop(0)
                continue

            if args and arg == "-user":
                self.user = args.pop(0)
                continue

            if args and arg == "-status":
                self.status = args.pop(0)
                continue

            if args and arg == "-avMemUsage":
                self.av_mem_usage = args.pop(0)
                continue

            if args and arg == "-avRenderTime":
                self.av_render_time = args.pop(0)
                continue


class RRftParseException(Exception):
    pass


def do_it():
    parser = RoyalFTStatParser(*sys.argv)
    if not parser.success:
        raise RRftParseException(parser.error)

    ftID = parser.ftid
    if ((len(ftID)<=1) or (ftID=="none")):
        print("Job has no ftrack ID.")
        return

    print("Update render stats in ftrack")

    import royalFTrack
    from royalFTrack import rrJob

    oRRFT = royalFTrack.royalFTrack()
    oRRFT.session_setup(parser.user)

    oRenderjob = rrJob.from_ftrack_id(ftID)
    if oRenderjob:
        oRenderjob.iAverageRendertime = parser.av_render_time
        oRenderjob.iAverageMemoryUsage = parser.av_mem_usage
        oRenderjob.status = parser.status
        oRenderjob.ft_metadata_set()

do_it()
