import rrGlobal
import sys


class RoyalSGPrevParser(object):
    def __init__(self, *args):
        self._path_size = 5
        self._debug = False
        
        self.path_list = [''] * self._path_size
        self.sgid = None
        self.status = None

        self.parse(args)
        self.error = ""
        self.success = self._is_valid()
    
    def _is_valid(self):
        if self._debug:
            print("sgid", self.sgid)
            print("status", self.status)
            print("paths", self.path_list)

        if not self.sgid:
            self.error = "Missing argument: -sgid (Shotgun ID)"
            return False
        if not self.status:
            self.error = "Missing argument: -status (Render Entity State)"
            return False
        for path in self.path_list:
            if path:
                return True
        
        self.error = "Missing argument: -p1, -p2... -p5 (preview paths)"

        return False

    def parse(self, args):
        args = list(args)
        if not args:
            raise Exception("no arguments given: -sgdi SHOTGUN_ID -p1 PATH_1 -p2... -status RENDER_STATUS")

        while args:
            arg = args.pop(0)
            if arg == "-debug":
                self._debug = True
                continue

            if args and arg == "-sgid":
                self.sgid = args.pop(0)
                continue
            
            if args and arg.startswith("-p") and len(arg) == 3 and arg[-1].isdigit():
                path_idx = int(arg[-1]) - 1
                if path_idx < self._path_size:
                    self.path_list[path_idx] = args.pop(0)
                continue

            if args and arg == "-status":
                self.status = args.pop(0)


class RRsgParseException(Exception):
    pass

def addPreviewCmd():
    print("Adding preview images to shotgun")
    
    parser = RoyalSGPrevParser(*sys.argv)
    if not parser.success:
        raise RRsgParseException(parser.error)
            
    shreID = parser.sgid
    if (not shreID or (shreID=="none")):
        print("Job has no Shotgun ID.")
        return
    
    import royalRifle
    global rRifle
    rRifle=royalRifle.RoyalRifle()
    
    rRifle.addPreviewImages(int(shreID), parser.path_list)
    rRifle.setRenderEntityState(int(shreID), parser.status)
  

addPreviewCmd()
