import rrGlobal
import sys


class RoyalSGQTParser(object):
    def __init__(self, *args):
        self._debug = False
        
        self.sgid = None
        self.movh = None
        self.movl = None

        self.parse(args)
        self.error = ""
        self.success = self._is_valid()
    
    def _is_valid(self):
        if self._debug:
            print("sgid", self.sgid)
            print("movh", self.movh)
            print("movl", self.movl)

        if not self.sgid:
            self.error = "Missing argument: -sgid (Shotgun ID)"
            return False
        if not self.movh:
            self.error = "Missing argument: -movh (High Res Quicktime)"
            return False
        if not self.movl:
            self.error = "Missing argument: -movl (Low Res Quicktime)"
            return False
        
        return True

    def parse(self, args):
        args = list(args)
        if not args:
            raise Exception("no arguments given: -sgdi SHOTGUN_ID -movh HIGH_RES_MOV -movl LOW_RES_MOV")

        while args:
            arg = args.pop(0)
            if arg == "-debug":
                self._debug = True
                continue

            if args and arg == "-sgid":
                self.sgid = args.pop(0)
                continue
            
            if args and arg == "-movh":
                self.movh = args.pop(0)
                continue

            if args and arg == "-movl":
                self.movl = args.pop(0)
                continue


class RRsgParseException(Exception):
    pass


def addQuicktimeCmd():
    print("Adding quicktime to shotgun")
    
    parser = RoyalSGQTParser(*sys.argv)
    if not parser.success:
        raise RRsgParseException(parser.error)

    shreID = parser.sgid
    if (not shreID or (shreID=="none")):
        print("Job has no Shotgun ID.")
        return
    
    import royalRifle
    global rRifle
    rRifle=royalRifle.RoyalRifle()

    rRifle.addQuicktime(int(shreID), parser.movh, parser.movl)
  

addQuicktimeCmd()
