# -*- coding: cp1252 -*-
#
# These lines are just information lines for the plugin loader
# rrPluginName:		Innobright Altus config file reader
# rrPluginAuthor:	Holger Schoenberger
# rrPluginVersion:	%rrVersion%
# rrPluginType:		Scene Parser Plugin
# rrRRversion:		8.0
#
#
#
# This setting is important for scene parser job plugins and need to be set.
# 
# rrSupportedFileExt: *.cfg;
#
#
#
# Copyright (c) Holger Schoenberger - Binary Alchemy
######################################################################
import os


def splitVarValue(line):
    var=""
    value=""
    if (line.find("=")>0): 
        splitted= line.split("=")
        var=splitted[0]
        value=splitted[1]
    return var, value


sceneFile= rr.sceneFileToLoad();
content=[]
try:
    with open(sceneFile) as f:
        content = f.readlines()
except Exception as e:
    rrGlobal.writeLog(rrGlobal.logLvL.progress, "Error loading file: "+str(e),"") #info messages will only be shown in the small log window of the rrSubmitter, but do not show a dialog window. As we do not want two dialog windows, see next lint
    rr.returnFromPlugin(rrGlobal.pluginReturn.fileFailedToOpen)  # this shows a general message window
    raise rrCleanExit() #I do not want any traceback info

if (len(content)<10):
    rr.returnFromPlugin(rrGlobal.pluginReturn.unsupportedFormat)  
    raise rrCleanExit() #I do not want any traceback info

isAltusFile=False
sceneVersion=""
for li in range(0, 10):   
    if (content[li].find("ALTUS COMMAND")>0):
        isAltusFile=True
    if (content[li].find("version")>0):
        sceneVersion=content[li]
        sceneVersion = ''.join([i for i in sceneVersion if (i.isdigit() or i=='.')]) #keep only numbers and points
    
if (not isAltusFile):
    rr.returnFromPlugin(rrGlobal.pluginReturn.unsupportedFormat)  
    raise rrCleanExit() #I do not want any traceback info

seqStart=1
seqEnd=1
seqStep=1
outputFile=""    
GPURrequired=False
for line in content:   
    if (content[li].find("START GUI CONFIG")>0):
        break
    var, value= splitVarValue(line)
    if (var == "out-path"):
        outputFile= value
    elif (var == "StartFrame"):
        seqStart= int(value)
    elif (var == "EndFrame"):
        seqEnd= int(value)
    elif (var == "Frame_Radius"):
        seqStep= int(value)
    elif (var == "gpu"):
        GPURrequired= True
        

if len(outputFile)<2:
    rr.returnFromPlugin(rrGlobal.pluginReturn.noImageOutput)  
    raise rrCleanExit() 

   
#Create a job
renderApp= rrJob._RenderAppBasic()
renderApp.clear()
renderApp.name="Altus"
renderApp.setVersionBoth(sceneVersion)


newJob=  rr.getNewJob()
newJob.sceneName=sceneFile;
newJob.renderApp=renderApp
newJob.imageFileName=outputFile
newJob.imageSingleOutputFile=False
newJob.splitImageFileInto_DirFileExt(False)
newJob.uiIsChecked= True
newJob.seqStart=seqStart
newJob.seqEnd=seqEnd
newJob.seqStep=seqStep
if (GPURrequired):
    newJob.customSet_Str("rrSubmitterParameter","GPUrequired=1~1") #note: This is an per-job override which will be applied when the job is send. It is not a global rrSubmitter override which will show in the UI.


rr.jobAll_set(999,newJob);  #If the index of the job is larger than the number of jobs,a new job is added to the end of the job list. So I used 999.

rr.returnFromPlugin(rrGlobal.pluginReturn.successful)