# -*- coding: cp1252 -*-
#
# These lines are just information lines for the plugin loader
# rrPluginName:		Nokia OZO config file reader
# rrPluginAuthor:	Holger Schoenberger
# rrPluginVersion:	%rrVersion%
# rrPluginType:		Scene Parser Plugin
# rrRRversion:		8.0
#
#
#
# This setting is important for scene parser job plugins and need to be set.
# 
# rrSupportedFileExt: *.json;
#
#
#
# Copyright (c) Holger Schoenberger - Binary Alchemy
######################################################################
import os



def splitVarValue(line):
    var=""
    value=""
    if (line.find(":")>0): 
        line=line.replace('\t','')
        line=line.replace('\r','')
        line=line.replace('\n','')
        splitted= line.split(":")
        var=splitted[0]
        var=var.replace('"','')
        var=var.replace(' ','')

        value=splitted[1]
        for i in range(2, len(splitted)):
            value+=":" + splitted[i]
        value=value.replace(',','')
        pos= value.find('"') 
        if (pos>=0):
            value= value[pos+1:]
            pos= value.find('"') 
            if (pos>=0):
                value= value[:pos]
    return var, value


#the file is a valid .json file, but the python json module is not able to load it

sceneFile= rr.sceneFileToLoad();
content=[]


try:
    with open(sceneFile) as f:
        content = f.readlines()
except Exception as e:
    rrGlobal.writeLog(rrGlobal.logLvL.progress, "Error loading file: "+str(e),"") #info messages will only be shown in the small log window of the rrSubmitter, but do not show a dialog window. As we do not want two dialog windows, see next lint
    rr.returnFromPlugin(rrGlobal.pluginReturn.fileFailedToOpen)  # this shows a general message window
    raise rrCleanExit() #I do not want any traceback info

seqStart=1
seqEnd=-1
seqStep=1
outputFile=""    
nrOutputs=0
isFileNode= False
for line in content:   
    if (isFileNode and line.find("}")>0):
        isFileNode= False
    var, value= splitVarValue(line)
    
    if (var == "outputs"):
        nrOutputs= nrOutputs+1
    elif (var == "out"):
        seqEnd= int(value)
    elif (var == "frameCount" and seqEnd<0):
        seqEnd= int(value)
    elif (var == "in"):
        seqStart= int(value)
    elif (var == "file"):
        isFileNode= True
    elif (isFileNode and var == "root"):
        outputFile= value + outputFile
    elif (isFileNode and var == "tail"):
        outputFile= outputFile + value
        
        
if (nrOutputs>1):
    rrGlobal.writeLog(rrGlobal.logLvL.warning, "Error loading file: You are allowed to have only one output in each .json file.","")
    raise rrCleanExit() #I do not want any traceback info

if len(outputFile)<2:
    rr.returnFromPlugin(rrGlobal.pluginReturn.noImageOutput)  
    raise rrCleanExit() 

outputFile= outputFile.replace("cam%d","cam<Camera>")
outputFile= outputFile.replace("%%","%")



   
#Create a job
renderApp= rrJob._RenderAppBasic()
renderApp.clear()
renderApp.name="NokiaOZO"

newJob=  rr.getNewJob()
newJob.sceneName=sceneFile;
newJob.renderApp=renderApp
newJob.camera="8"
newJob.imageFileName=outputFile
newJob.imageSingleOutputFile=False
newJob.splitImageFileInto_DirFileExt(True)
newJob.uiIsChecked= True
newJob.seqStart=seqStart
newJob.seqEnd=seqEnd
newJob.seqStep=1
newJob.customSet_Str("rrSubmitterParameter","GPUrequired=1~1") #note: This is an per-job override which will be applied when the job is send. It is not a global rrSubmitter override which will show in the UI.


rr.jobAll_set(999,newJob);  #If the index of the job is larger than the number of jobs,a new job is added to the end of the job list. So I used 999.

rr.returnFromPlugin(rrGlobal.pluginReturn.successful)