import  reporter
import datetime
import time

startDay = rrReportTime.startDay()
startWeekDay = rrReportTime.startWeekDay()
endDay = rrReportTime.endDay()
reportDayCount = endDay- startDay +1

timerange_str="\n {} - {}".format(rrReportTime.startTime_datetime().strftime('CW%W  %d.%b.%Y'),rrReportTime.endTime_datetime().strftime('%d.%b.%Y'))

if (RequestClientName == "") :
    Header.setLabel("Client Summary - All Clients" + timerange_str )
else:
    Header.setLabel("Client Summary '"+RequestClientName+"'" + timerange_str )



rrGlobal.progress_SetMaxC(2)
rrGlobal.progress_SetProgressC(0)
rrGlobal.progress_hideET_C()


#-------------------------------------------------------------------------------------
#some error checking

err = rrClientStats.getError() #e.g. unable to load, stats folder not found, ...
if err != "":
    raise Exception("rrClientStats Precheck: " + err) 


rrGlobal.progress_SetMaxA(rrClientStats.clientCount())
rrGlobal.progress_SetProgressLabelA(0, "clients")
rrGlobal.progress_SetProgressLabelB(0, "load iteration")
rrGlobal.progress_SetMaxB(2)
rrGlobal.progress_SetInfo("Pre-Loading Client stats into memory... 1/2")
rrGlobal.refreshUI()

rrClientStats.setDelayedLoad_FileAge(50); #realmReporter waits 3 seconds before loading a stat file if the  filedate has  +/- 50 seconds difference compared to the time of this machine
    
#preloading client stats and checking for error messages
#IMPORTANT: 
# A) If you have hundrets of clients, this app might take 30 GB of RAM
# B) The data is kept im memory and not refreshed as long as this realmReporter app is running.
# C) If a file cannot be loaded, then realmReporter tries to load it again the next time you press "generate".


#The first time we load all clients, but ignore error messages.
#E.g. if a client is currently writing its stats (done every 2 hours), we cannot load it
rrGlobal.progress_SetProgressLabelB(0, "load iteration")
wasLoadError= False
for cIdx in range(0, rrClientStats.clientCount()):
    if ((cIdx % 5)==0):
        rrGlobal.progress_SetProgressLabelA(cIdx, "clients")
        freeMem= reporter.rrGetAvailableMemoryMB()
        if (freeMem<1000):
            #We want to exit before the rrClientStats loader uses all memory on the machine. (Which might make the OS unstable)
            #Note: The only way to process that much data is NOT to preload the data and process it in chunks and use rrClientStats.freeMem() 
            raise Exception("Not enough memory! Loaded {} of {}. Memory used: {} MiB. Memory required: {} MiB".format(cIdx,rrClientStats.clientCount(), rrClientStats.memUsageMiB(), int ( rrClientStats.memUsageMiB()//cIdx*rrClientStats.clientCount() )  )) 
    for dayIdx in range(startDay, endDay+1):
        if RequestClientName!="" and RequestClientName!=rrClientStats.getName(cIdx):
            continue
        rrClientStats.getData_period_day_hasData(cIdx, dayIdx)
        err= rrClientStats.getError() 
        if err!="":
            rrGlobal.writeLog2(rrGlobal.logLvL.info, rrClientStats.getName(cIdx) + ": " + err )
            wasLoadError=True
        if rrGlobal.progress_CancelPressed():
            raise rrCleanExit()

rrGlobal.progress_SetProgressLabelB(1, "load iteration")
rrGlobal.progress_SetInfo("Pre-Loading Client stats into memory... 2/2")
#this time we try to load it, but show an error to the user
if wasLoadError:
    time.sleep(10)
    for cIdx in range(0, rrClientStats.clientCount()):
        if ((cIdx % 5)==0):
            rrGlobal.progress_SetProgressLabelA(cIdx, "clients")
            freeMem= reporter.rrGetAvailableMemoryMB()
            if (freeMem<1000):
                raise Exception("Not enough memory! Loaded {} of {}. Memory used: {} MiB. Memory required: {} MiB".format(cIdx,rrClientStats.clientCount(), rrClientStats.memUsageMiB(), int ( rrClientStats.memUsageMiB()//cIdx*rrClientStats.clientCount() )  )) 
        for dayIdx in range(startDay, endDay+1):
            if RequestClientName!="" and RequestClientName!=rrClientStats.getName(cIdx):
                continue
            rrClientStats.getData_period_day_hasData(cIdx, dayIdx)
            err= rrClientStats.getError() 
            if err!="":
                raise Exception(rrClientStats.getName(cIdx) + ": " + err) 
            if rrGlobal.progress_CancelPressed():
                raise rrCleanExit()
        
            
            
rrGlobal.progress_SetInfo("Generating charts...")

#-------------------------------------------------------------------------------------
#TableNet      
rrGlobal.progress_SetProgressC(1)

avTrafficIn=0
avTrafficOut=0
clAvTrafficIn=0
clAvTrafficOut=0
maxAllTrafficIn=0
maxAllTrafficOut=0
maxOneTrafficIn=0
maxOneTrafficOut=0
maxOneTrafficInClient=""
maxOneTrafficOutClient=""


speedMaxIn=0
speedMaxClient=""



#rrGlobal.writeLog2(rrGlobal.logLvL.info,"TableIdleRendering: Client Count: "+ str(rrClientStats.clientCount()))

rrGlobal.progress_SetInfo("TableInfo...")
rrGlobal.progress_SetProgressLabelA(0, "clients")
rrGlobal.progress_SetProgressLabelB(0, "day")
rrGlobal.progress_SetMaxA(rrClientStats.clientCount())
rrGlobal.progress_SetMaxB(endDay-startDay+1)


for dayIdx in range(startDay, endDay+1):
    rrGlobal.progress_SetProgressLabelB(dayIdx-startDay, "day")
    dayClCount = 0 
    dayAllTrafficIn=0
    dayAllTrafficOut=0
    for cIdx in range(0, rrClientStats.clientCount()):
        if ((cIdx % 5)==0):
            rrGlobal.progress_SetProgressLabelA(cIdx, "clients")
        if RequestClientName!="" and RequestClientName!=rrClientStats.getName(cIdx):
            continue
        if not rrClientStats.getData_period_day_hasData(cIdx, dayIdx): #was the client online that day?
            continue
        dayClCount= dayClCount+1
        clDayTrafficIn=0
        clDayTrafficOut=0
        clientDay= rrClientStats.getData_period_day(cIdx, dayIdx)
        sCount= clientDay.dataMax()
        for slot in range (0, sCount):
            if not clientDay.data(slot).hasData(): #was the client online at that time?
                continue
            if (clientDay.data(slot).networkInMB < 0): #old version did not support it. The value was set to -1   
                continue              
            #rrGlobal.writeLog2(rrGlobal.logLvL.info,str(clientDay.data(slot).networkInSpeedMaxMB) )
            if (speedMaxIn < clientDay.data(slot).networkInSpeedMaxMB):
                speedMaxIn = clientDay.data(slot).networkInSpeedMaxMB
                speedMaxClient= rrClientStats.getName(cIdx)
            clDayTrafficIn= clDayTrafficIn + clientDay.data(slot).networkInMB
            clDayTrafficOut= clDayTrafficOut + clientDay.data(slot).networkOutMB
            
            
        if maxOneTrafficIn < clDayTrafficIn:
            maxOneTrafficIn = clDayTrafficIn
            maxOneTrafficInClient= rrClientStats.getName(cIdx)
        if maxOneTrafficOut < clDayTrafficOut:
            maxOneTrafficOut = clDayTrafficOut
            maxOneTrafficOutClient= rrClientStats.getName(cIdx)
        avTrafficIn= avTrafficIn + clDayTrafficIn
        avTrafficOut= avTrafficOut + clDayTrafficOut
        dayAllTrafficIn= dayAllTrafficIn + clDayTrafficIn
        dayAllTrafficOut= dayAllTrafficOut + clDayTrafficOut      
        #rrGlobal.writeLog2(rrGlobal.logLvL.info,"TableIdleRendering: Adding "+ str(rrClientStats.getName(cIdx)) + " clDayTrafficIn " + str(clDayTrafficIn)  + " clDayTrafficOut " + str(clDayTrafficOut) )
        #end of client

    if (dayClCount>0):    
        clAvTrafficIn= clAvTrafficIn + (dayAllTrafficIn /  dayClCount)
        clAvTrafficOut= clAvTrafficOut + (dayAllTrafficOut /  dayClCount) 
    if maxAllTrafficIn < dayAllTrafficIn:
        maxAllTrafficIn = dayAllTrafficIn
    if maxAllTrafficOut < dayAllTrafficOut:
        maxAllTrafficOut = dayAllTrafficOut     
    #end of day
    
avTrafficIn= avTrafficIn //  reportDayCount
avTrafficOut= avTrafficOut //  reportDayCount
clAvTrafficIn= int(clAvTrafficIn) //  reportDayCount
clAvTrafficOut= int(clAvTrafficOut) //  reportDayCount



TableNet.setRowName(0 , "Average traffic per day all clients")
TableNet.setRowName(1 , "Average traffic per day per client")
TableNet.setRowName(2 , "Max traffic at one day all clients")
TableNet.setRowName(3 , "Max traffic at one day at one client")
TableNet.setRowName(4 , "Max Speed In") 
TableNet.setColName(0, "In")
TableNet.setColName(1, "Out")

TableNet.setColName(2, "Client")
TableNet.setColName(3, "Client")

    
TableNet.setCell(0, 0, str(avTrafficIn // 1024) + " GiB" )
TableNet.setCell(1, 0, str(avTrafficOut // 1024) + " GiB" )
TableNet.setCell(0, 1, str(clAvTrafficIn // 1024) + " GiB" )
TableNet.setCell(1, 1, str(clAvTrafficOut // 1024) + " GiB" )
TableNet.setCell(0, 2, str(maxAllTrafficIn // 1024) + " GiB" )
TableNet.setCell(1, 2, str(maxAllTrafficOut // 1024) + " GiB" )
TableNet.setCell(0, 3, str(maxOneTrafficIn // 1024) + " GiB" )
TableNet.setCell(1, 3, str(maxOneTrafficOut // 1024) + " GiB" )

TableNet.setCell(2, 3, maxOneTrafficInClient )
TableNet.setCell(3, 3, maxOneTrafficOutClient )

TableNet.setCell(0, 4, str(speedMaxIn) + " MB/s" )
TableNet.setCell(1, 4, "-" )
TableNet.setCell(2, 4, speedMaxClient )
 
    
    
    
#-------------------------------------------------------------------------------------
#LineTraffic   
rrGlobal.progress_SetProgressC(2)


rrGlobal.progress_SetInfo("TableTraffic...")
rrGlobal.progress_SetProgressLabelA(0, "clients")
rrGlobal.progress_SetProgressLabelB(0, "day")
rrGlobal.progress_SetMaxA(rrClientStats.clientCount())
rrGlobal.progress_SetMaxB(endDay-startDay+1)

LineTraffic.setYAxisMax(200)

lineIdx=-1
for cIdx in range(0, rrClientStats.clientCount()):
    if ((cIdx % 5)==0):
        rrGlobal.progress_SetProgressLabelA(cIdx, "clients")

    if RequestClientName!="" and RequestClientName!=rrClientStats.getName(cIdx):
        continue 
    thisClientAdded = False

    for dayIdx in range(startDay, endDay+1):
        rrGlobal.progress_SetProgressLabelB(dayIdx-startDay, "day")
        #rrGlobal.writeLog2(rrGlobal.logLvL.info,"TableIdleRendering: check "+ str(rrClientStats.getName(cIdx)))
        if not rrClientStats.getData_period_day_hasData(cIdx, dayIdx): #was the client online that day?
            continue
        #rrGlobal.writeLog2(rrGlobal.logLvL.info,"TableIdleRendering: online "+ str(rrClientStats.getName(cIdx)))
        
        clientDay= rrClientStats.getData_period_day(cIdx, dayIdx)
        sph= clientDay.dataMax()//24  #slots per hour
        sCount= clientDay.dataMax()

        lastHourID= -1  #to know that we have moved to the next hour
        thisHour_WasOnline= False
        thisHour_MaxTraffic= 0

        for slot in range (0, sCount):
            hour= slot // sph
            if lastHourID != hour:
                if lastHourID >= 0:
                    if not thisClientAdded:
                        thisClientAdded= True
                        lineIdx= lineIdx +1
                    hourSinceStart= (dayIdx-startDay)*24  + lastHourID
                    if not thisHour_WasOnline:
                        thisHour_MaxTraffic=500
                    LineTraffic.addPoint(lineIdx, hourSinceStart, thisHour_MaxTraffic)
                thisHour_MaxTraffic= 0
                lastHourID = hour
                thisHour_WasOnline= False
                
                
            if not clientDay.data(slot).hasData(): #was the client online at that time?
                continue
            if not clientDay.data(slot).anyThreadRendering():
                continue
            thisHour_WasOnline= True
            
            if thisHour_MaxTraffic < clientDay.data(slot).networkInSpeedMaxMB:
                thisHour_MaxTraffic = clientDay.data(slot).networkInSpeedMaxMB

        hourSinceStart= (dayIdx-startDay)*24  + lastHourID
        if not thisHour_WasOnline:
            thisHour_MaxTraffic=500
        LineTraffic.addPoint(lineIdx, hourSinceStart, thisHour_MaxTraffic)
           
    
    