import  reporter
import datetime

startDay = rrReportTime.startDay()
startWeekDay = rrReportTime.startWeekDay()
endDay = rrReportTime.endDay()
reportDayCount = endDay- startDay +1

#if set to "last week"
#timerange_str="\n{} - {}".format(rrReportTime.startTime_datetime().strftime('CW%W  %d.%b.%Y'), rrReportTime.endTime_datetime().strftime('%d.%b.%Y'))
#if set to "last month"
timerange_str="\n{} - {}".format(rrReportTime.startTime_datetime().strftime('%B  %d.%b.%Y'), rrReportTime.endTime_datetime().strftime('%d.%b.%Y'))

Header.setLabel("RenderStats Comparison " + str(timerange_str) )



class perPrj:
    avFrameTime=0
    avMemUsageMB=0
    avPSUsage=0
    totalPSUsage=0
    totalWattUsage=0
    totalCost=0
    framesRendered=0
    maxFrameTime=0
    maxMemUsageMB=0
    count=0
    
prjDict= {}

for dayIdx in range(startDay, endDay+1):
    if not rrDailyStats.period_day_hasData(dayIdx):
        continue
    statPrjList= rrDailyStats.period_day(dayIdx).getJobsByType(1)
    rrGlobal.writeLog2(rrGlobal.logLvL.info, str(prjDict) )
    for prj in statPrjList:
        if (not prj.name in prjDict):
            prjDict[prj.name]= perPrj() #create new
            
        prjCollect= prjDict[prj.name]
        for sIdx in range(0, prj.timeSlotCount()):
            slot= prj.getTimeSlot(sIdx)
            if not slot.hasValidData():
                continue
            prjCollect.count          = prjCollect.count + 1
            prjCollect.avFrameTime    = prjCollect.avFrameTime + slot.avFrameTime
            prjCollect.avMemUsageMB   = prjCollect.avMemUsageMB + slot.avMemUsageMB
            prjCollect.avPSUsage      = prjCollect.avPSUsage + slot.avPSUsage
            prjCollect.totalPSUsage   = prjCollect.totalPSUsage + slot.avPSUsage
            #prjCollect.totalWattUsage = prjCollect.totalWattUsage + slot.avPSUsage
            #prjCollect.totalCost      = prjCollect.totalCost + slot.avPSUsage
            prjCollect.framesRendered = prjCollect.framesRendered + slot.framesRendered
            if (prjCollect.maxFrameTime <slot.maxFrameTime):
                prjCollect.maxFrameTime = slot.maxFrameTime
            if (prjCollect.maxMemUsageMB <slot.maxMemUsageMB):
                prjCollect.maxMemUsageMB = slot.maxMemUsageMB
                 
        prjDict[prj.name]= prjCollect


BarFrameTimes.addSection("Average")
BarFrameTimes.addSection("Max")
BarMemory.addSection("Average")
BarMemory.addSection("Max")

BarPS.addSection("Average Client PS used")
BarPSTotal.addSection("Total kPS*s used")
BarFrameCount.addSection("Total Frames rendered")

        
for prjName in prjDict:
    prj= prjDict[prjName]
    if prj.count==0:
        continue 
    print(prj)        
    prj.avPSUsage = prj.avPSUsage // prj.count
    prj.avMemUsageMB  = prj.avMemUsageMB // prj.count
    prj.avFrameTime = prj.avFrameTime // prj.count
    prjCollect.totalPSUsage= prjCollect.totalPSUsage * 15 * 60  #Convert PS into PS*sec
    prjCollect.totalPSUsage= prjCollect.totalPSUsage // 1000    #Convert PS*sec into kPS*sec
    
    idx= BarFrameTimes.addBarName(prjName)
    BarMemory.addBarName(prjName)
    BarPS.addBarName(prjName)
    BarPSTotal.addBarName(prjName)
    BarFrameCount.addBarName(prjName)
     
    BarFrameTimes.setValue(idx, 0, prj.avFrameTime)
    BarFrameTimes.setValue(idx, 1, prj.maxFrameTime)

    BarMemory.setValue(idx, 0, (prj.avMemUsageMB // 1024 ))
    BarMemory.setValue(idx, 1, (prj.maxMemUsageMB // 1024 ))
    
    BarPS.setValue(idx, 0, prj.avPSUsage)
    
    BarPSTotal.setValue(idx, 0, prj.totalPSUsage)
    
    BarFrameCount.setValue(idx, 0, prj.framesRendered)
    
    

#------------------------render apps

prjDict= {}

for dayIdx in range(startDay, endDay+1):
    if not rrDailyStats.period_day_hasData(dayIdx):
        continue
    statPrjList= rrDailyStats.period_day(dayIdx).getJobsByType(2)
    rrGlobal.writeLog2(rrGlobal.logLvL.info, str(prjDict) )
    for prj in statPrjList:
        if (not prj.name in prjDict):
            prjDict[prj.name]= perPrj() #create new
            
        prjCollect= prjDict[prj.name]
        for sIdx in range(0, prj.timeSlotCount()):
            slot= prj.getTimeSlot(sIdx)
            if not slot.hasValidData():
                continue
            prjCollect.count          = prjCollect.count + 1
            prjCollect.avFrameTime    = prjCollect.avFrameTime + slot.avFrameTime
            prjCollect.avMemUsageMB   = prjCollect.avMemUsageMB + slot.avMemUsageMB
            prjCollect.avPSUsage      = prjCollect.avPSUsage + slot.avPSUsage
            prjCollect.totalPSUsage   = prjCollect.totalPSUsage + slot.avPSUsage
            prjCollect.framesRendered = prjCollect.framesRendered + slot.framesRendered
            if (prjCollect.maxFrameTime <slot.maxFrameTime):
                prjCollect.maxFrameTime = slot.maxFrameTime
            if (prjCollect.maxMemUsageMB <slot.maxMemUsageMB):
                prjCollect.maxMemUsageMB = slot.maxMemUsageMB
                 
        prjDict[prj.name]= prjCollect


BarFrameTimesR.addSection("Average")
BarFrameTimesR.addSection("Max")
BarMemoryR.addSection("Average")
BarMemoryR.addSection("Max")

BarPSR.addSection("Average Client PS used")
BarPSTotalR.addSection("Total kPS*s used")
BarFrameCountR.addSection("Total Frames rendered")

        
for prjName in prjDict:
    prj= prjDict[prjName]
    if prj.count==0:
        continue 
    print(prj)        
    prj.avPSUsage = prj.avPSUsage // prj.count
    prj.avMemUsageMB  = prj.avMemUsageMB // prj.count
    prj.avFrameTime = prj.avFrameTime // prj.count
    prjCollect.totalPSUsage= prjCollect.totalPSUsage * 15 * 60  #Convert PS into PS*sec
    prjCollect.totalPSUsage= prjCollect.totalPSUsage // 1000    #Convert PS*sec into kPS*sec
    
    idx= BarFrameTimesR.addBarName(prjName)
    BarMemoryR.addBarName(prjName)
    BarPSR.addBarName(prjName)
    BarPSTotalR.addBarName(prjName)
    BarFrameCountR.addBarName(prjName)
     
    BarFrameTimesR.setValue(idx, 0, prj.avFrameTime)
    BarFrameTimesR.setValue(idx, 1, prj.maxFrameTime)

    BarMemoryR.setValue(idx, 0, (prj.avMemUsageMB // 1024 ))
    BarMemoryR.setValue(idx, 1, (prj.maxMemUsageMB // 1024 ))
    
    BarPSR.setValue(idx, 0, prj.avPSUsage)
    
    BarPSTotalR.setValue(idx, 0, prj.totalPSUsage)
    
    BarFrameCountR.setValue(idx, 0, prj.framesRendered)    