#
# Render App License Example
#
# Get and set render app licenses using Global Info via python
#
# Calling tcp.infoGetGlobalInfo() stores the Render Farm information in tcp.info,
#
# tcp.info.licenses can be used to access and modify render app licenses
#


import sys
import os

mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)

from rr_python_utils.load_rrlib import rrLib  # module libpyRR3 for python 3, libpyRR2 for python 2
import rr_python_utils.connection as rr_connect


def get_and_set_licenses(tcp, save_changes=False):
    # Get Global Information from server
    tcp.infoGetGlobalInfo()

    print("Render App Licenses\n")
    for i in range(tcp.info.licenses.count()):
        license = tcp.info.licenses.at(i)

        print(f"\n {license.softwareName}, {license.pluginName}:")
        if license.isEnabled(rrLib._rrClientType.default):
            print(f"\t Using {license.inUse(rrLib._rrClientType.default)} of {license.count(rrLib._rrClientType.default)} Default licenses")

        if license.isEnabled(rrLib._rrClientType.workstation):
            print(f"\t Using {license.inUse(rrLib._rrClientType.workstation)} of {license.count(rrLib._rrClientType.workstation)} Workstation licenses")
        
        if license.isEnabled(rrLib._rrClientType.renderfarm):
            print(f"\t Using {license.inUse(rrLib._rrClientType.renderfarm)} of {license.count(rrLib._rrClientType.renderfarm)} Renderfarm licenses")

        if license.isEnabled(rrLib._rrClientType.cloud):
            print(f"\t Using {license.inUse(rrLib._rrClientType.cloud)} of {license.count(rrLib._rrClientType.cloud)} Cloud licenses")


        
        add_count = 10
        cloud_count = license.count(rrLib._rrClientType.cloud)
        print(f"\n\tIncreasing Cloud License Count ({cloud_count}) of", add_count)
        license.setCount(rrLib._rrClientType.cloud, cloud_count + add_count)
        print("\tCloud License Count is now", license.count(rrLib._rrClientType.cloud), "-- THIS CHANGE HAS NOT BEEN SAVED YET --")
    
    if save_changes:
        if tcp.infoSaveLicense():
            print("\nNew License Config was sent to the server")
        else:
            print("\nLicense Config was not sent properly", tcp.errorMessage())
    else:
        print("\nChanges will not be saved, exiting")

def block__and_return_licenses(tcp):
    # Get Global Information from server
    tcp.infoGetGlobalInfo()

    print("-----------block__and_return_licenses-----------------\n")
    if (tcp.info.licenses.count()>0):
        license = tcp.info.licenses.at(0)
        if tcp.freeLicense(license, rrLib._rrClientType.default):
            print("\n\t Freeing one license for artist...")

            # must update info to check just blocked license!!
            tcp.infoGetGlobalInfo()
            print("\t Blocked licenses:", license.blocked(rrLib._rrClientType.default))
        else:
            print("\n\t Could not free license for artist", tcp.errorMessage())

        if tcp.returnLicense(license, rrLib._rrClientType.default):
            print("\t Reclaimed one license from artist.")
            # must update info to check just blocked license!!
            tcp.infoGetGlobalInfo()
            print("\t Blocked licenses:", license.blocked(rrLib._rrClientType.default))
        else:
            print("\t Could not reclaim license from artist...")
            
            
if __name__ == "__main__":
    import argparse

    parser = argparse.ArgumentParser()
    parser.add_argument("--user")

    args = parser.parse_args()

    rr_tcp = rr_connect.server_connect(user_name=args.user, askForlogin=False)
    get_and_set_licenses(rr_tcp, save_changes=False)
    block__and_return_licenses(rr_tcp)
