#
# Description:
# This scripts loads the statistics files of all clients.
# It calculates:
#   - The average CPU usage of the OS for each day
#   - The average CPU usage of all Jobs for each day
#   - The total number of frames rendered for each day
#
# And saves them as .csv file, which you can load into Excel.
#
# You need to execute this python script with rrPythonconsole
#
import os
import sys


mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)

from rr_python_utils.load_rrdata import rrData
from os import listdir
from os.path import isfile, join
from datetime import datetime
import time


if rrData.getModuleVersionMajor()<9:
   raise Exception("Incompatible RR Version" )

exportFolder = rrData.getRRFolder_root() + "inhouse/"



if "rrGlobal" not in sys.modules:
    raise Exception("This script is intended to be run within rrPythonconsole to support .csv export." )


# Note: Please check your license via rrControl/help menu of you have access to the class rrTable
rrTableClient = rrGlobal._rrTable()
rrTableClient.setHeader(0, "Client")
rrTableClient.setHeader(1, "Was a user logged in any time?")
rrTableClient.setHeader(2, "CPU usage percent")
rrTableClient.setHeader(3, "GPU usage percent")
rrTableClient.setHeader(4, "Total memory usage in MB, divided by 10.")
rrTableClient.setHeader(5, "Frames done")
rrTableClient.setHeader(6, "Job crashes")
rrTableClient.setHeader(7, "Job aborts")
rrTableClient.setHeader(8, "Job successes")


# _clientStats_all

clientStatList = rrData._clientStats_all()
#in case you are not executing this function that has the env var RR_ROOT set, you have to call  clientStatList.initFileList( "//fileserver/share/RR/sub/stats/clients")
#clientStatList.initFileList( "//fileserver/Renderfarm/RR/sub/stats/clients")

print (str(clientStatList.clientCount()) + " files found.")


#python function to calculate days in unix time 
yesterday = time.mktime(time.localtime()) /24/60/60
yesterday = int( yesterday -1 )
print("Yesterday in UnixDays at localtimeZone:  " + str(yesterday))

#RR function 
yesterday= clientStatList.currentUnixDayLocal() - 1
print("Yesterday in UnixDays at localtimeZone:  " + str(yesterday))

cLoaded = 0
cUsed = 0
row = 1


try:
    for cIdx in range(0,clientStatList.clientCount()):
        cName= clientStatList.getName(cIdx)
        cData= clientStatList.getData(cIdx)
        if clientStatList.getData_error(cIdx):
            print(" | Error:  unable to load stats file " + cName + "! " + clientStatList.getError())
            continue;
        cLoaded=cLoaded+1
        if (not cData.period_day_hasData(yesterday)):
            print("{:<15}: no data for the day.".format(cName))
            continue;
        cUsed=cUsed+1
        print("{:<15}: EXPORTING...".format(cName))
        
        sday=cData.period_day(yesterday)
        rrTableClient.setString(0, row, cName)
        cpu_amount_OS = 0
        gpu_total = 0
        system_memory_total = 0
        count = 0
        was_user_ever_logged_in = False
        for h in range(0, sday.dataMax()):
            sData = sday.data(h)
            if (not sData.hasData()):
                continue
            cpu_amount_OS = cpu_amount_OS + sData.cpuTotal
            gpu_total = gpu_total + sData.gpuTotal
            system_memory_total = system_memory_total + sData.memTotal10MB
            if sData.userLoggedIn:
                was_user_ever_logged_in = True
            count = count + 1
        if (count > 0):
            cpu_amount_OS = cpu_amount_OS / count
            gpu_total = gpu_total / count
            system_memory_total = system_memory_total / count

        frame_count = 0
        job_crash_count = 0
        job_abort_count = 0
        job_success_count = 0
        for h in range(0, sday.dataHourlyMax()):
            hData = sday.dataHourly(h)
            for jTH in range(0, hData.jobThreadCount()):    
                if (not hData.jobThread(jTH).hasData()):
                    continue
                frame_count += hData.jobThread(jTH).framesDone
                job_crash_count += hData.jobThread(jTH).jobCrashed
                job_abort_count += hData.jobThread(jTH).jobAborted
                job_success_count += hData.jobThread(jTH).jobSuccessful

        rrTableClient.setString(1, row, str(was_user_ever_logged_in))

        rrTableClient.setFloat(2, row, cpu_amount_OS)
        rrTableClient.setFloat(3, row, gpu_total)
        rrTableClient.setFloat(4, row, system_memory_total)

        rrTableClient.setInt(5, row, frame_count)
        rrTableClient.setInt(6, row, job_crash_count)
        rrTableClient.setInt(7, row, job_abort_count)
        rrTableClient.setInt(8, row, job_success_count)
        row += 1

except:
    print(str(traceback.format_exc()))
   

print ("\n\nclientStatList: Memory usage: "+ str(clientStatList.memUsageMiB()) + " MiB.")
clientStatList.freeMem() #if your machine should not use that much RAM, you might want to call freeMem() every few executions in the loop above
print ("clientStatList: Memory usage: "+ str(clientStatList.memUsageMiB()) + " MiB.")

print ("{} of {} stats used.".format(cUsed, cLoaded))

out_csv = "{0}ClientStats_{1}_{2}.csv".format(exportFolder, datetime.now().strftime('%Y_%m_%d'), "yesterday")
if not rrTableClient.saveAsCsv(out_csv, False):
    print ("Error: Unable to save user table! " + rrTableClient.fileError())


print("Saved into folder " + exportFolder)
print("\n\n--- DONE ---\n\n")


