# Last change: %rrVersion%
# Copyright (c) Holger Schoenberger - Binary Alchemy


# This example script loads jobs of a specified project from the current rrServer queue and from the history database.
# It collects data from the custom client usage counter "Watt" (Can be used for anything beside real Watt as well)

import sys
import os
import shutil
import traceback
import tempfile
from datetime import datetime

mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)

if sys.version_info.major == 2:
    range = xrange
       
    
from rr_python_utils.load_rrlib import rrLib
from rr_python_utils.load_rrdata import rrData
import rrJob    

#-------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------
    

import logging
# TODO: final logging directory for Royal Render
_TEMP_DIR = tempfile.gettempdir()
_TEMP_NAME = "rrWattCounter.log"

# create logger
logger = logging.getLogger("rrS")
logger.setLevel(logging.DEBUG)
ch = logging.StreamHandler()
ch.setLevel(logging.DEBUG)

# create formatter and add it to the handlers
formatter = logging.Formatter("%(asctime)s %(name)s| %(levelname)s:  %(message)s", "%H:%M:%S")
ch.setFormatter(formatter)

# add the handlers to the logger
logger.addHandler(ch)


#-------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------



projectName="renderfarm"
summed_Wh=0






### --------------------------------------------------------------------- INIT
logger.debug("Set up server and login info.")
tcp = rrLib._rrTCP("")
rrServer= tcp.getRRServer() #This function does only work in your company. It uses the RR_ROOT environment installed by rrWorkstationInstaller
if (len(rrServer)==0):
    logger.error(tcp.errorMessage())
if not tcp.setServer(rrServer, 7773):
    logger.error ("Error setServer: "+ tcp.errorMessage())
    sys.exit()
  

#IMPORTANT: If you set a password, then the rrServer enables its authorization check.
#           This means this user HAS TO to exist in RR.
#           If you are running this script from your local intranet, you probably do not need a password.
#           Please see rrHelp section Usage/External Connections/Security
tcp.setLogin("SomeUser", "somePass")


if not tcp.connectAndAuthorize():
    logger.error("Error authorizing at the rrServer: " + tcp.errorMessage())
    sys.exit(2)


### --------------------------------------------------------------------- JOBS
### IMPORTANT: tcp caches all jobs, if you destroy it, the rrServer has to send all jobs again
### A list request will always be executed, so you have a list of all jobs at the rrServer
### But to reduce traffic, you should set a filter for the jobs you need before you request more data
### There are three levels of job information:
### MinInfo: The list, all jobs with ID, user, software, project
### Basic:   Scene information
### Send:    All job data you can have

   
logger.info("Checking live jobs")
#jobList_SetFilter3(QString user, QString project, QString renderApp,  quint16 ageHours, QString contains, bool invert, quint15 filter)
tcp.jobList_SetFilter3("",projectName, "", 0, "", False, rrLib._filterIDs.isAll); 


#if not tcp.jobList_GetBasic(): //use this command if you do not need the full information about a job

if not tcp.jobList_GetSend():
  logger.error("Error getting jobs: " + tcp.errorMessage())
else:
  jobs = tcp.jobs
  logger.debug("Number of jobs: " + str(jobs.getMaxJobs()))
  nbJobs = jobs.getMaxJobsFiltered()
  logger.info("Number of jobs - filtered by project "+str(projectName)+": " + str(nbJobs))
  for i in range(0, nbJobs):
    jID = jobs.getJobMinInfo_filterQueue(i).ID
    job = jobs.getJobSend(jID)
    if (job.infoRenderTimeSum_WattSec > 0):
        summed_Wh = summed_Wh +  (job.infoRenderTimeSum_WattSec /60/60 )    
        logger.debug("   " + job.IDstr()+"\t WattSec: "+str(job.infoRenderTimeSum_WattSec)  )
    else:
        #jobs rendered before this custom counter was available
        assumed_Wh = job.infoRenderTimeSum_seconds *400 /60 /60
        summed_Wh = summed_Wh +  assumed_Wh
        logger.debug("   " + job.IDstr()+"\t WattSec: "+str( assumed_Wh)+ " (ASSUMED) "  )
    

logger.info("Checking history dabatase jobs")

dbFolder =  rrData.getRRFolder_historydb()
hdb= rrData._historyProjectLoader()
if not hdb.loadProjectList(dbFolder):
    logger.error(hdb.errorString())
    sys.exit(3)

foundID=-1
projectNameLower= projectName.lower()
for i in range(hdb.projectCount()):
    if (hdb.projectName(i).lower() == projectNameLower):
        foundID=i
        
if (foundID<0):
    logger.warning("project not found in historyDB")
else:
    hdb.loadProject(foundID)
    for i in range(hdb.jobCount()):
        job= hdb.jobAt(i)
        if (job.infoRenderTimeSum_WattSec > 0):
            summed_Wh = summed_Wh +  (job.infoRenderTimeSum_WattSec /60/60 )    
            logger.debug("   " + job.IDstr()+"\t WattSec: "+str(job.infoRenderTimeSum_WattSec)  )
        else:
            #jobs rendered before this custom counter was available
            #infoRenderTimeSum_seconds was not available as well, so we use Ghz*h
            averageGhzPerMachine=100
            assumed_Wh = int(job.infoRenderTimeSum_Ghz_h * 400 / averageGhzPerMachine)  
            summed_Wh = summed_Wh +  assumed_Wh
            logger.debug("   " + job.ID2str()+"\t WattSec: "+str( assumed_Wh)+ " (ASSUMED) "  )        



logger.info("\n\nTotal wH of project "+projectName+":  "+str(summed_Wh) +"\nTotal kwH of project "+projectName+":  "+str(summed_Wh/1000)+"\n\n")

logger.info("\n\n--- DONE ---\n\n")
