import  reporter
import datetime
import time

startDay = rrReportTime.startDay()
startWeekDay = rrReportTime.startWeekDay()
endDay = rrReportTime.endDay()
reportDayCount = endDay- startDay +1

timerange_str="\n {} - {}".format(rrReportTime.startTime_datetime().strftime('CW%W  %d.%b.%Y'),rrReportTime.endTime_datetime().strftime('%d.%b.%Y'))

if (RequestClientName == "") :
    Header.setLabel("Client Summary - All Clients" + timerange_str )
else:
    Header.setLabel("Client Summary '"+RequestClientName+"'" + timerange_str )



rrGlobal.progress_SetMaxC(7)
rrGlobal.progress_SetProgressC(0)
rrGlobal.progress_hideET_C()


#-------------------------------------------------------------------------------------
#some error checking

err = rrClientStats.getError() #e.g. unable to load, stats folder not found, ...
if err != "":
    raise Exception("rrClientStats Precheck: " + err) 


rrGlobal.progress_SetMaxA(rrClientStats.clientCount())
rrGlobal.progress_SetProgressLabelA(0, "clients")
rrGlobal.progress_SetProgressLabelB(0, "load iteration")
rrGlobal.progress_SetMaxB(2)
rrGlobal.progress_SetInfo("Pre-Loading Client stats into memory... 1/2")
rrGlobal.refreshUI()

rrClientStats.setDelayedLoad_FileAge(50); #realmReporter waits 3 seconds before loading a stat file if the  filedate has  +/- 50 seconds difference compared to the time of this machine
    
#preloading client stats and checking for error messages
#IMPORTANT: 
# A) If you have hundrets of clients, this app might take 30 GB of RAM
# B) The data is kept im memory and not refreshed as long as this realmReporter app is running.
# C) If a file cannot be loaded, then realmReporter tries to load it again the next time you press "generate".


#The first time we load all clients, but ignore error messages.
#E.g. if a client is currently writing its stats (done every 2 hours), we cannot load it
rrGlobal.progress_SetProgressLabelB(0, "load iteration")
wasLoadError= False
for cIdx in range(0, rrClientStats.clientCount()):
    if ((cIdx % 5)==0):
        rrGlobal.progress_SetProgressLabelA(cIdx, "clients")
        freeMem= reporter.rrGetAvailableMemoryMB()
        if (freeMem<1000):
            #We want to exit before the rrClientStats loader uses all memory on the machine. (Which might make the OS unstable)
            #Note: The only way to process that much data is NOT to preload the data and process it in chunks and use rrClientStats.freeMem() 
            raise Exception("Not enough memory! Loaded {} of {}. Memory used: {} MiB. Memory required: {} MiB".format(cIdx,rrClientStats.clientCount(), rrClientStats.memUsageMiB(), int ( rrClientStats.memUsageMiB()//cIdx*rrClientStats.clientCount() )  )) 
    for dayIdx in range(startDay, endDay+1):
        if RequestClientName!="" and RequestClientName!=rrClientStats.getName(cIdx):
            continue
        rrClientStats.getData_period_day_hasData(cIdx, dayIdx)
        err= rrClientStats.getError() 
        if err!="":
            rrGlobal.writeLog2(rrGlobal.logLvL.info, rrClientStats.getName(cIdx) + ": " + err )
            wasLoadError=True
        if rrGlobal.progress_CancelPressed():
            raise rrCleanExit()

rrGlobal.progress_SetProgressLabelB(1, "load iteration")
rrGlobal.progress_SetInfo("Pre-Loading Client stats into memory... 2/2")
#this time we try to load it, but show an error to the user
if wasLoadError:
    time.sleep(10)
    for cIdx in range(0, rrClientStats.clientCount()):
        if ((cIdx % 5)==0):
            rrGlobal.progress_SetProgressLabelA(cIdx, "clients")
            freeMem= reporter.rrGetAvailableMemoryMB()
            if (freeMem<1000):
                raise Exception("Not enough memory! Loaded {} of {}. Memory used: {} MiB. Memory required: {} MiB".format(cIdx,rrClientStats.clientCount(), rrClientStats.memUsageMiB(), int ( rrClientStats.memUsageMiB()//cIdx*rrClientStats.clientCount() )  )) 
        for dayIdx in range(startDay, endDay+1):
            if RequestClientName!="" and RequestClientName!=rrClientStats.getName(cIdx):
                continue
            rrClientStats.getData_period_day_hasData(cIdx, dayIdx)
            err= rrClientStats.getError() 
            if err!="":
                raise Exception(rrClientStats.getName(cIdx) + ": " + err) 
            if rrGlobal.progress_CancelPressed():
                raise rrCleanExit()
        
            
            
rrGlobal.progress_SetInfo("Generating charts...")

#-------------------------------------------------------------------------------------
#TableNet      
rrGlobal.progress_SetProgressC(1)

avTrafficIn=0
avTrafficOut=0
clAvTrafficIn=0
clAvTrafficOut=0
maxAllTrafficIn=0
maxAllTrafficOut=0
maxOneTrafficIn=0
maxOneTrafficOut=0
maxOneTrafficInClient=""
maxOneTrafficOutClient=""


speedMaxIn=0
speedMaxClient=""



#rrGlobal.writeLog2(rrGlobal.logLvL.info,"TableIdleRendering: Client Count: "+ str(rrClientStats.clientCount()))

rrGlobal.progress_SetInfo("TableIdleRendering...")
rrGlobal.progress_SetProgressLabelA(0, "clients")
rrGlobal.progress_SetProgressLabelB(0, "day")
rrGlobal.progress_SetMaxA(rrClientStats.clientCount())
rrGlobal.progress_SetMaxB(endDay-startDay+1)


for dayIdx in range(startDay, endDay+1):
    rrGlobal.progress_SetProgressLabelB(dayIdx-startDay, "day")
    dayClCount = 0 
    dayAllTrafficIn=0
    dayAllTrafficOut=0
    for cIdx in range(0, rrClientStats.clientCount()):
        if ((cIdx % 5)==0):
            rrGlobal.progress_SetProgressLabelA(cIdx, "clients")
        if RequestClientName!="" and RequestClientName!=rrClientStats.getName(cIdx):
            continue
        if not rrClientStats.getData_period_day_hasData(cIdx, dayIdx): #was the client online that day?
            continue
        dayClCount= dayClCount+1
        clDayTrafficIn=0
        clDayTrafficOut=0
        clientDay= rrClientStats.getData_period_day(cIdx, dayIdx)
        sCount= clientDay.dataMax()
        for slot in range (0, sCount):
            if not clientDay.data(slot).hasData(): #was the client online at that time?
                continue
            if (clientDay.data(slot).networkInMB < 0): #old version did not support it. The value was set to -1   
                continue              
            #rrGlobal.writeLog2(rrGlobal.logLvL.info,str(clientDay.data(slot).networkInSpeedMaxMB) )
            if (speedMaxIn < clientDay.data(slot).networkInSpeedMaxMB):
                speedMaxIn = clientDay.data(slot).networkInSpeedMaxMB
                speedMaxClient= rrClientStats.getName(cIdx)
            clDayTrafficIn= clDayTrafficIn + clientDay.data(slot).networkInMB
            clDayTrafficOut= clDayTrafficOut + clientDay.data(slot).networkOutMB
        if maxOneTrafficIn < clDayTrafficIn:
            maxOneTrafficIn = clDayTrafficIn
            maxOneTrafficInClient= rrClientStats.getName(cIdx)
        if maxOneTrafficOut < clDayTrafficOut:
            maxOneTrafficOut = clDayTrafficOut
            maxOneTrafficOutClient= rrClientStats.getName(cIdx)
        avTrafficIn= avTrafficIn + clDayTrafficIn
        avTrafficOut= avTrafficOut + clDayTrafficOut
        dayAllTrafficIn= dayAllTrafficIn + clDayTrafficIn
        dayAllTrafficOut= dayAllTrafficOut + clDayTrafficOut      
        #rrGlobal.writeLog2(rrGlobal.logLvL.info,"TableIdleRendering: Adding "+ str(rrClientStats.getName(cIdx)) + " clDayTrafficIn " + str(clDayTrafficIn)  + " clDayTrafficOut " + str(clDayTrafficOut) )
        #end of client

    if (dayClCount>0):    
        clAvTrafficIn= clAvTrafficIn + (dayAllTrafficIn /  dayClCount)
        clAvTrafficOut= clAvTrafficOut + (dayAllTrafficOut /  dayClCount) 
    if maxAllTrafficIn < dayAllTrafficIn:
        maxAllTrafficIn = dayAllTrafficIn
    if maxAllTrafficOut < dayAllTrafficOut:
        maxAllTrafficOut = dayAllTrafficOut     
    #end of day
    
avTrafficIn= avTrafficIn //  reportDayCount
avTrafficOut= avTrafficOut //  reportDayCount
clAvTrafficIn= int(clAvTrafficIn) //  reportDayCount
clAvTrafficOut= int(clAvTrafficOut) //  reportDayCount



TableNet.setRowName(0 , "Average traffic per day all clients")
TableNet.setRowName(1 , "Average traffic per day per client")
TableNet.setRowName(2 , "Max traffic at one day all clients")
TableNet.setRowName(3 , "Max traffic at one day at one client")
TableNet.setRowName(4 , "Max Speed In") 
TableNet.setColName(0, "In")
TableNet.setColName(1, "Out")

TableNet.setColName(2, "Client")
TableNet.setColName(3, "Client")

    
TableNet.setCell(0, 0, str(avTrafficIn // 1024) + " GiB" )
TableNet.setCell(1, 0, str(avTrafficOut // 1024) + " GiB" )
TableNet.setCell(0, 1, str(clAvTrafficIn // 1024) + " GiB" )
TableNet.setCell(1, 1, str(clAvTrafficOut // 1024) + " GiB" )
TableNet.setCell(0, 2, str(maxAllTrafficIn // 1024) + " GiB" )
TableNet.setCell(1, 2, str(maxAllTrafficOut // 1024) + " GiB" )
TableNet.setCell(0, 3, str(maxOneTrafficIn // 1024) + " GiB" )
TableNet.setCell(1, 3, str(maxOneTrafficOut // 1024) + " GiB" )

TableNet.setCell(2, 3, maxOneTrafficInClient )
TableNet.setCell(3, 3, maxOneTrafficOutClient )

TableNet.setCell(0, 4, str(speedMaxIn) + " MB/s" )
TableNet.setCell(1, 4, "-" )
TableNet.setCell(2, 4, speedMaxClient )
 
    
    
    
#-------------------------------------------------------------------------------------
#1) Rendering to idle percentage. Disabled Clients are not taken into account. 
#2) CPU usage of all machines
#Offline Clients are taken into account if they have been online for some time on that day
rrGlobal.progress_SetProgressC(2)
rrGlobal.writeLog2(rrGlobal.logLvL.info, "TableIdleRendering/TableCPU: Client Count: "+ str(rrClientStats.clientCount()))
rrGlobal.progress_SetInfo("TableCPU...")
rrGlobal.progress_SetProgressLabelA(0, "clients")
rrGlobal.progress_SetProgressLabelB(0, "day")


   
for idx in range(0,24):
    TableIdleRendering.setRowName(idx, '  ' + str(idx) + ':00  ')
    TableCPU.setRowName(idx, '  ' + str(idx) + ':00  ')




for dayIdx in range(startDay, endDay+1):
    rrGlobal.progress_SetProgressLabelB(dayIdx-startDay, "day")

    if (rrReportTime.day2weekday(dayIdx)=="Sun"): # in case this report was generated for a full month
        TableIdleRendering.setColName(dayIdx-startDay, "Sun " + rrReportTime.day2dm(dayIdx) )
        TableCPU.setColName(dayIdx-startDay, "Sun " + rrReportTime.day2dm(dayIdx) )
    elif (rrReportTime.day2weekday(dayIdx)=="Mon"): # in case this report was generated for a full month
        TableIdleRendering.setColName(dayIdx-startDay, "Mon " + rrReportTime.day2dm(dayIdx) )
        TableCPU.setColName(dayIdx-startDay, "Mon " + rrReportTime.day2dm(dayIdx) )
    else:
        TableIdleRendering.setColName(dayIdx-startDay, rrReportTime.day2dm(dayIdx) )
        TableCPU.setColName(dayIdx-startDay, rrReportTime.day2dm(dayIdx) )
    clCount = [0 for y in range(24)] 
    clRendering = [0 for y in range(24)] 
    clCPU = [0 for y in range(24)]
    clCPUcount = [0 for y in range(24)]
    for cIdx in range(0, rrClientStats.clientCount()):
        if ((cIdx % 5)==0):
            rrGlobal.progress_SetProgressLabelA(cIdx, "clients")
    
        if RequestClientName!="" and RequestClientName!=rrClientStats.getName(cIdx):
            continue 
        #rrGlobal.writeLog2(rrGlobal.logLvL.info,"TableIdleRendering: check "+ str(rrClientStats.getName(cIdx)))
        if not rrClientStats.getData_period_day_hasData(cIdx, dayIdx): #was the client online that day?
            continue
        #rrGlobal.writeLog2(rrGlobal.logLvL.info,"TableIdleRendering: online "+ str(rrClientStats.getName(cIdx)))
        
        clientDay= rrClientStats.getData_period_day(cIdx, dayIdx)
        sph= clientDay.dataMax()//24  #slots per hour
        sCount= clientDay.dataMax()
        for slot in range (0, sCount):
            hour= slot // sph
            if not clientDay.data(slot).hasData(): #was the client online at that time?
                clCount[hour]= clCount[hour]+1  #We know Client was online that day. This means it existed and could have rendered if someone would have turned it on
                continue
            if clientDay.data(slot).anyThreadRendering():
                clRendering[hour]= clRendering[hour]+1
                clCount[hour]= clCount[hour]+1
            elif clientDay.data(slot).anyThreadIdle():
                clCount[hour]= clCount[hour]+1
            clCPU[hour]= clCPU[hour] + clientDay.data(slot).cpuTotal
            clCPUcount[hour]= clCPUcount[hour]+1
            
            
                
    for hour in range(0,24):
        if clCount[hour]>0:
            floatRatio= clRendering[hour] / clCount[hour]
            TableIdleRendering.setCellColor(dayIdx-startDay, hour, reporter.rrTextPercent(floatRatio,0), reporter.rrColorGradientHeat(floatRatio,0.9) )
        else:
            TableIdleRendering.setCell(dayIdx-startDay, hour, "-" )
            
        if clCPUcount[hour]>0:
            floatRatio= clCPU[hour] / clCPUcount[hour]
            floatRatio= floatRatio / 100 # the cpuTotal value is in percent 0-100. And rrTextPercent() takes 0-1 as percent.
            TableCPU.setCellColor(dayIdx-startDay, hour, reporter.rrTextPercent(floatRatio,0), reporter.rrColorGradientHeat(floatRatio,0.9) )
        else:
            TableCPU.setCell(dayIdx-startDay, hour, "-" )
        
    
    
#-------------------------------------------------------------------------------------
#Client Status
rrGlobal.progress_SetProgressC(3)
rrGlobal.progress_SetProgressLabelA(0, "clients")
rrGlobal.progress_SetProgressLabelB(0, "day")

rrGlobal.progress_SetInfo("PieStatus...")

countIdle=0
countOffline=0
countRendering=0  
countDisabled=0  
    
for dayIdx in range(startDay, endDay+1):
    rrGlobal.progress_SetProgressLabelB(dayIdx-startDay, "day")
    for cIdx in range(0, rrClientStats.clientCount()):
        if ((cIdx % 5)==0):
            rrGlobal.progress_SetProgressLabelA(cIdx, "clients")
        if RequestClientName!="" and RequestClientName!=rrClientStats.getName(cIdx):
            continue
        if not rrClientStats.getData_period_day_hasData(cIdx, dayIdx): #was the client online that day?

            cData= rrClientStats.getData(cIdx)
            lastDay= cData.getDayByIdx(cData.daysCount()-1).day
            if (lastDay > startDay-30):  #we do not want to count clients that are not in the farm any more for a month
                countOffline= countOffline + 24*60*60//30 # we add a whole offline day. Issue: If a client was removed from the farm, it is added anyway...
            continue
        
        clientDay= rrClientStats.getData_period_day(cIdx, dayIdx)
        sCount= clientDay.dataMax()
        for slot in range (0, sCount):
            if not clientDay.data(slot).hasData(): #was the client online at that time?
                countOffline= countOffline + 1
                continue
            #infoLine= "{:.2f}".format(slot*24  / sCount) 
            #infoLine= infoLine + " th:" + str(clientDay.data(slot).jobThreadCount())
            #infoLine= infoLine + " status:" + str(clientDay.data(slot).jobThread(0).clientStatus)
            #if clientDay.data(slot).anyThreadRendering():
            #    infoLine= infoLine + " yRen: TRUE "
            #else:
            #    infoLine= infoLine + " yRen: FALSE"
            #if clientDay.data(slot).allThreadsDisabled():
            #    infoLine= infoLine + " lDis: TRUE "
            #else:
            #    infoLine= infoLine + " lDis: FALSE"
            #if clientDay.data(slot).anyThreadIdle():
            #    infoLine= infoLine + " yIdle: TRUE "
            #else:
            #    infoLine= infoLine + " yIdle: FALSE"
            #rrGlobal.writeLog2(rrGlobal.logLvL.info, infoLine )
            
            if clientDay.data(slot).anyThreadRendering():
                countRendering= countRendering + 1
            elif clientDay.data(slot).allThreadsDisabled():
                countDisabled= countDisabled + 1
            else:
                countIdle= countIdle +1            
         
PieStatus.addSlice_Color(countOffline, 'Offline', 0x666666)      
PieStatus.addSlice_Color(countIdle, 'Idle', 0xDDDDDD )    
PieStatus.addSlice_Color(countDisabled, 'Disabled', 0xDD8822 )  
PieStatus.addSlice_Color(countRendering, 'Rendering', 0x00CC00 )  
    


#-------------------------------------------------------------------------------------
#Client CPU % while rendering
rrGlobal.progress_SetProgressC(4)
rrGlobal.progress_SetProgressLabelA(0, "clients")
rrGlobal.progress_SetProgressLabelB(0, "day")
rrGlobal.progress_SetInfo("PieCPU...")

countJob=0
countOther=0
countNone=0  
 
    
for dayIdx in range(startDay, endDay+1):
    rrGlobal.progress_SetProgressLabelB(dayIdx-startDay, "day")

    for cIdx in range(0, rrClientStats.clientCount()):
        if ((cIdx % 5)==0):
            rrGlobal.progress_SetProgressLabelA(cIdx, "clients")
        if RequestClientName!="" and RequestClientName!=rrClientStats.getName(cIdx):
            continue
        if not rrClientStats.getData_period_day_hasData(cIdx, dayIdx): #was the client online that day?
            continue
        
        clientDay= rrClientStats.getData_period_day(cIdx, dayIdx)
        sCount= clientDay.dataMax()
        for slot in range (0, sCount):
            if not clientDay.data(slot).hasData(): #was the client online at that time?
                continue
            if clientDay.data(slot).anyThreadRendering():
                #infoLine= "{:.2f}".format(slot*24  / sCount) 
                #infoLine= infoLine + " th:" + str(clientDay.data(slot).jobThreadCount())
                #infoLine= infoLine + " status:" + str(clientDay.data(slot).jobThread(0).clientStatus)
                #infoLine= infoLine + "  rAll {:.2f}".format(clientDay.data(slot).cpuRender_allThreads()) 
                #infoLine= infoLine + "  rOne {:.2f}".format(clientDay.data(slot).jobThread(0).cpuRender) 
                #infoLine= infoLine + "  Total {:.2f}".format(clientDay.data(slot).cpuTotal) 
                #infoLine= infoLine + "  " + rrClientStats.getName(cIdx)
                #rrGlobal.writeLog2(rrGlobal.logLvL.info, infoLine )
                countJob= countJob  + clientDay.data(slot).cpuRender_allThreads()
                countOther= countOther + clientDay.data(slot).cpuTotal - clientDay.data(slot).cpuRender_allThreads() 
                countNone= countNone + 100 - clientDay.data(slot).cpuTotal
                
         
PieCPU.addSlice_Color(countJob, 'Job', 0x00EE00)      
PieCPU.addSlice_Color(countOther, 'Not Job', 0x006600 )    
PieCPU.addSlice_Color(countNone, 'Idle', 0x000000 )  
      
    
    

    
#-------------------------------------------------------------------------------------
#Job 
rrGlobal.progress_SetProgressC(5)
rrGlobal.progress_SetProgressLabelA(0, "clients")
rrGlobal.progress_SetProgressLabelB(0, "day")
rrGlobal.progress_SetInfo("PieJob...")

countCrashed=0
countAborted=0  
countSuccess=0    
countFrames=0
  
for dayIdx in range(startDay, endDay+1):
    rrGlobal.progress_SetProgressLabelB(dayIdx-startDay, "day")

    for cIdx in range(0, rrClientStats.clientCount()):
        if ((cIdx % 5)==0):
            rrGlobal.progress_SetProgressLabelA(cIdx, "clients")

        if RequestClientName!="" and RequestClientName!=rrClientStats.getName(cIdx):
            continue
        if not rrClientStats.getData_period_day_hasData(cIdx, dayIdx): #was the client online that day?
            continue
        
        clientDay= rrClientStats.getData_period_day(cIdx, dayIdx)
        hCount= clientDay.dataHourlyMax()
        for slot in range (0, hCount):
            dataH =clientDay.dataHourly(slot)
            thCount= dataH.jobThreadCount()
            for th in range (0, thCount):
                countCrashed= countCrashed + dataH.jobThread(th).jobCrashed
                countAborted= countAborted + dataH.jobThread(th).jobAborted
                countSuccess= countSuccess + dataH.jobThread(th).jobSuccessful
                countFrames= countFrames + dataH.jobThread(th).framesDone
                
         
PieJob.addSlice_Color(countCrashed, 'Crashed', 0xDD0000)        
PieJob.addSlice_Color(countAborted, 'Aborted', 0xDD8822 )          
PieJob.addSlice_Color(countSuccess, 'Successful', 0x00CC00 )      
    
PieJob.setDescription("Frames rendered: " + str(countFrames))
    

    
#-------------------------------------------------------------------------------------
#Multiple per Group stats 
gCount= rrClientGroupList.count

rrGlobal.writeLog2(rrGlobal.logLvL.info, "Client Group Count: "+str(gCount))
rrGlobal.progress_SetProgressC(6)
rrGlobal.progress_SetProgressLabelB(0, "group")
rrGlobal.progress_SetProgressLabelA(0, "clients")
rrGlobal.progress_SetMaxB(gCount)
rrGlobal.progress_SetInfo("BarCpu/Mem/...")



BarStatusNorm.addSection_color('Offline', 0x666666)
BarStatusNorm.addSection_color('Idle', 0xDDDDDD)
BarStatusNorm.addSection_color('Disabled', 0xDD8822)
BarStatusNorm.addSection_color('Rendering', 0x00CC00 )

BarStatus.addSection_color('Offline', 0x666666)
BarStatus.addSection_color('Idle', 0xDDDDDD)
BarStatus.addSection_color('Disabled', 0xDD8822)
BarStatus.addSection_color('Rendering', 0x00CC00 )

BarCpu.addSection_color('Job', 0x00EE00)
BarCpu.addSection_color('Not Job', 0x006600 )
BarCpu.addSection_color('Idle', 0x000000)

BarJob.addSection_color('Crashed', 0xDD0000)
BarJob.addSection_color('Aborted', 0xDD8822 )
BarJob.addSection_color('Successful', 0x00CC00)

BarMem.addSection_color('Memory', 0xCC5555)


timerBefore=datetime.datetime.now()
for grpIdx in range(0, gCount):
    rrGlobal.progress_SetProgressLabelB(grpIdx, "group")
    if rrGlobal.progress_CancelPressed():
        raise rrCleanExit()
    groupName=rrClientGroupList.clientGroup( grpIdx).getName()
    rrGlobal.writeLog2(rrGlobal.logLvL.info,"Group: {}  with {} clients".format( groupName,rrClientGroupList.clientGroup( grpIdx).count()))
    BarStatusNorm.addBarName(groupName)
    BarStatus.addBarName(groupName)
    BarCpu.addBarName(groupName)
    BarJob.addBarName(groupName)
    BarMem.addBarName(groupName)

    countOffline=0
    countIdle=0
    countDisabled=0  
    countRendering=0  

    countJob=0
    countOther=0
    countNone=0 

    countCrashed=0
    countAborted=0  
    countSuccess=0    
    
     
    maxMemory =0
    rrGlobal.progress_SetMaxA(rrClientGroupList.clientGroup( grpIdx).count())
    
    for cIdx in range(0, rrClientGroupList.clientGroup( grpIdx).count()):
        if ((cIdx % 5)==0):
            rrGlobal.progress_SetProgressLabelA(cIdx, "clients")
        #rrGlobal.writeLog2(rrGlobal.logLvL.info, "Group: {}  idx: {}/{} ".format(groupName, cIdx, rrClientGroupList.clientGroup( grpIdx).count()))
        loopClName= rrClientGroupList.clientGroup(grpIdx).getClientName(cIdx)
        for dayIdx in range(startDay, endDay+1):
            if not rrClientStats.getDataByName_period_day_hasData(loopClName, dayIdx): #was the client online that day?
                continue
                
            clientDay= rrClientStats.getDataByName_period_day(loopClName, dayIdx)
            hCount= clientDay.dataHourlyMax()
            for slot in range (0, hCount):
                dataH =clientDay.dataHourly(slot)
                thCount= dataH.jobThreadCount()
                for th in range (0, thCount):
                    countCrashed= countCrashed + dataH.jobThread(th).jobCrashed
                    countAborted= countAborted + dataH.jobThread(th).jobAborted
                    countSuccess= countSuccess + dataH.jobThread(th).jobSuccessful
                    
            sCount= clientDay.dataMax()
            for slot in range (0, sCount):
                if not clientDay.data(slot).hasData(): #was the client online at that time?
                    countOffline= countOffline + 1
                    continue
                if clientDay.data(slot).anyThreadRendering():
                    countRendering= countRendering + 1
                elif clientDay.data(slot).allThreadsDisabled():
                    countDisabled= countDisabled + 1
                else:
                    countIdle= countIdle +1    
                    
                if clientDay.data(slot).anyThreadRendering():
                    countJob= countJob  + clientDay.data(slot).cpuRender_allThreads()
                    countOther= countOther + clientDay.data(slot).cpuTotal  - clientDay.data(slot).cpuRender_allThreads()
                    countNone= countNone + 100 - clientDay.data(slot).cpuTotal
                    
                if (maxMemory < clientDay.data(slot).memRender10MB_allThreads()):
                    maxMemory = clientDay.data(slot).memRender10MB_allThreads()

    maxMemory= maxMemory /1024 #convert into GiB

    BarStatusNorm.setValue(grpIdx, 0, countOffline)
    BarStatusNorm.setValue(grpIdx, 1, countIdle)
    BarStatusNorm.setValue(grpIdx, 2, countDisabled)
    BarStatusNorm.setValue(grpIdx, 3, countRendering)

    BarStatus.setValue(grpIdx, 0, countOffline)
    BarStatus.setValue(grpIdx, 1, countIdle)
    BarStatus.setValue(grpIdx, 2, countDisabled)
    BarStatus.setValue(grpIdx, 3, countRendering)


    BarCpu.setValue(grpIdx, 0, countJob)
    BarCpu.setValue(grpIdx, 1, countOther)
    BarCpu.setValue(grpIdx, 2, countNone)

    BarJob.setValue(grpIdx, 0, countCrashed)
    BarJob.setValue(grpIdx, 1, countAborted)
    BarJob.setValue(grpIdx, 2, countSuccess)

    BarMem.setValue(grpIdx, 0, maxMemory)

timerAfter=datetime.datetime.now()
timerAfter=timerAfter-timerBefore
                
rrGlobal.writeLog2(rrGlobal.logLvL.info,"Group timer: "+str(timerAfter)+"  h:m:s.ms")


#rrGlobal.progress_SetProgressC(7)
rrGlobal.progress_Hide()







# THE FOLLOWING CHECK WAS DISABLED!
# In case your client list contains more clients than stat files found, then the last loop 
# if not rrClientStats.getDataByName_period_day_hasData(loopClName, dayIdx):
# reports an error that the client was not found

#We are not checking for errors every time.
#And there should not be any issue.
#So far the only known error messages are:
#   - "unable to load", but that is already printed at the beginning of this script
#   - Loop/range was wrong and it reported "index out of range". So we check for this error now

#err= rrClientStats.getError() #was the stats folder found
#if err!="":
    #raise Exception("rrClientStats error : " + err) 








    
