#
#################################################################
#
#   PLEASE USE rrSubmitter menu Scripted Jobs/Create Weekly Stats to create a .csv file with this script once a week.
#   You might want to set the "Start After" value of the job to Sunday evening.
#
#################################################################
#
#
# Reads the server daily stat files for the latest X days
# and saves a .csv file with line for each project
#
# You need to execute this python script with rrPythonconsole
#
# Syntax:
#     rrPythonconsole exportLastDaysTables.py NUM_DAYS EXPORT_FOLDER
#
# default values are -1 for NUM_DAYS and RR_ROOT/inhouse as export folder
#
# NUM_DAYS = -1 collects stats from all the dailystats that are found
# EXPORT_FOLDER must NOT end with "/"
#

import struct
import datetime
import shutil

import os
import sys

mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)

from rr_python_utils.load_rrdata import rrData

if rrData.getModuleVersionMajor()<9:
   raise Exception("Incompatible RR Version" )


if "rrGlobal" not in sys.modules:
    raise Exception("This script is intended to be run within rrPythonconsole to support .csv export." )


# Arguments

#optional argument to specify the number of days:
try:
    num_days = int(sys.argv[1])
except (IndexError, ValueError):
    num_days = 14
    
#argument to specify the output folder    
try:
    exportFolder = sys.argv[2]
except IndexError:
    exportFolder = rrGlobal.rrRootPath() + "inhouse"
if (exportFolder[0] == "-"):
    exportFolder = rrGlobal.rrRootPath() + "inhouse"
exportFolder+= "/"

if not os.path.isdir(exportFolder):
    os.mkdir(exportFolder)

# rrTable for storing projects stats
rrTableProjects = rrGlobal._rrTable()
rrTableProjects.setHeader(0, "Date")
rrTableProjects.setHeader(1, "RenderApp")
rrTableProjects.setHeader(2, "Average FrameTime in sec.")
rrTableProjects.setHeader(3, "Average Memory Usage")
rrTableProjects.setHeader(4, "Average PS Usage")
rrTableProjects.setHeader(5, "Frames Rendered")
rrTableProjects.setHeader(6, "Max FrameTime in sec")
rrTableProjects.setHeader(7, "Max Memory Usage in MB")
rrTableProjects.setHeader(8, "Max PSUsage")
rrTableProjects.setHeader(9, "Times Frame Segment Finished")
rrTableProjects.setHeader(10, "Times Frame Segment Sent")

dailyStatList= rrData._dailyStats_timeline()
#in case you are not executing this function that has the env var RR_ROOT set, you have to call  clientStatList.initFileList( "//fileserver/share/RR/sub/stats/clients")
dailyStatList.initFileList( "//bigfoot/Renderfarm/RR/sub/stats/server")



endDay= dailyStatList.currentUnixDayLocal()
startDay= endDay- num_days +1

print ("{} files being processed".format(endDay- startDay+1))

# dictionaries of total occurrences to average, per row

for day in range(startDay, endDay+1):
    if not dailyStatList.period_day_hasData(day):
        print(statFile+"| Error:  unable to load stats file! " + dailyStatList.getError())
    else:
        dayStat= dailyStatList.period_day(day)

        print("day: ", dayStat.fileNameDate())
        prjStat = dayStat.getJobsByType(2)  # list of render app stats

        for stats in prjStat:
            # load previous values
            
            rowDate= dayStat.fileNameDate().strftime("%d.%m.%Y")
            rowName= stats.name
            
            row = rrTableProjects.rowIndex(rowName, True)
            rrTableProjects.setString(0, row,rowDate)
            rrTableProjects.setString(1, row,rowName)
            print("        ",rowDate, rowName)

            avFrameTime = 0
            avMemUsageMB = 0
            avPSUsage = 0

            framesRendered = 0

            maxFrameTime = 0
            maxMemUsageMB = 0
            maxPSUsage = 0

            timesFinished = 0
            timesSended = 0

            avFrTime_count = 0
            avMemUse_count = 0
            avPSUse_count = 0
            
            
            for t in range(0, stats.statCount()):
                stat = stats.stats(t)  # stat for the t-th part of the day (each 15 mins)

                framesRendered += stat.framesRendered
                timesFinished += stat.timesFinished
                timesSended += stat.timesSended

                maxFrameTime = max(maxFrameTime, stat.maxFrameTime)
                maxMemUsageMB = max(maxMemUsageMB, stat.maxMemUsageMB)
                maxPSUsage = max(maxPSUsage, stat.maxPSUsage)

                if stat.avFrameTime:
                    avFrameTime += stat.avFrameTime
                    avFrTime_count += 1
                if stat.avMemUsageMB:
                    avMemUsageMB += stat.avMemUsageMB
                    avMemUse_count += 1
                if stat.avPSUsage:
                    avPSUsage += stat.avPSUsage
                    avPSUse_count += 1

            if (avFrTime_count>0):
                avFrameTime= avFrameTime /avFrTime_count
            if (avMemUse_count>0):
                avMemUsageMB= avMemUsageMB /avMemUse_count
            if (avPSUse_count>0):
                avPSUsage= avPSUsage /avPSUse_count
            # store current values
            rrTableProjects.setFloat(2, row, avFrameTime)
            rrTableProjects.setFloat(3, row, avMemUsageMB)
            rrTableProjects.setFloat(4, row, avPSUsage)

            rrTableProjects.setInt(5, row, framesRendered)

            rrTableProjects.setInt(6, row, maxFrameTime)
            rrTableProjects.setInt(7, row, maxMemUsageMB)
            rrTableProjects.setFloat(8, row, maxPSUsage)

            rrTableProjects.setInt(9, row, timesFinished)
            rrTableProjects.setInt(10, row, timesSended)

   
rrTableProjects.sortRowsByString()

out_csv = "{0}statsPerApp_{1}_{2}d.csv".format(exportFolder, datetime.date.today().strftime('%Y%m%d'),num_days)
if not rrTableProjects.saveAsCsv(out_csv, False):
    print ("Error: Unable to save project table to file '"+out_csv+"'! "+rrTableProjects.fileError())

print("Saved into folder " + exportFolder)
print("\n\n--- DONE ---\n\n")
