# Royal Render plugin
#
# Header information: RR reads the first comment block to get the settings for this plugin.
# You can write as many lines as you like
#
# These lines are just information lines for you and have no effect.  They are *not* required
# rrPluginName:		Shift job start time if job gets into main render approval
# rrPluginAuthor:	Holger Schoenberger
# rrPluginVersion:	1.0
# rrPluginType:		Job Status Plugin
# rrRRversion:		8.1
#
# Your finished script has to be copied into the folder [RR]\plugins64\server_jobstatus\
#
#
# These settings are important for server job plugins and have to be set.
# They tell the rrServer when the plugin should be executed. 
# A "1" activates the plugin for this execution step. Everything beside "1" (including nothing) disables it.
#
# rrJobExec FirstCheck:		   
# rrJobExec ScriptPreRender:	   
# rrJobExec PreviewRender:	   
# rrJobExec ScriptAfterPreview:	  
# rrJobExec WaitForApprovalPreview:   1
# rrJobExec MainRender:		   
# rrJobExec ScriptPostRender:	   
# rrJobExec WaitForApprovalDone:   
# rrJobExec ScriptFinished:	   
# rrJobExec Finished:		   
#
#
#


# The first line without a # will stop the header parser.
# Therefore these lines are not read any more.




#What does this script do?
#This script is triggered when a job gets into the state "WaitForApprovalPreview".
#If this job has approval enabled, it would wait for a user to approve it.
#(All other jobs without approval continue with the next job state MainRender)
#But instead of waiting for an approval, this script disables the job until 22:00 today



import datetime

job= rr.getJob()
if (job._RROptions(rrJob._RROptions.rroApprovalPreview)):
    rrGlobal.writeLog2(rrGlobal.logLvL.info,  "Shift job, Job found: " +job.IDstr())
    nowTime = datetime.datetime.now()
    laterTime= nowTime.replace(hour=22, minute=00)
    job.timeToEnable= laterTime
    rr.setJob(job)
    




