import os
import sys

from Framework.ActionFactory.Actions.Base import BaseAction
from Framework.MessageSystem.IMessageSystem import Message
from lux_data_layer.services import ServicesFacade
from Framework.Core import Configuration

import json
import linecache
#from Daemon.Actions.Core import schema_attributes as schema


try:
    from pxz import *
except:
    pass



# create json from CADCONV id
'''
service = ServicesFacade.shotgun_service_facade()

def create_json_for_pixyz(task_id=8562):    # that is 'CADCONV_Rim_1L_60' from project 'A0_0A02037'
    """
    Create a json for CADCONV:
    Given taks_id correspond to the CADCONV tasks whose Actions are required (Pixyz's tessellation)
    From CADCONV's task_id, its previous task of type 'Variant CAD-CREOB' is sought and its last version is fetched
    From CREOB's last version a proper .step file is put within JSON file (as the file to be loaded for conversion)
    CADCONV's xml_attribute is put within JSON file (as tessellation parameters)
    CADCONV's SANDBOX location is produces and put within JSON file (as the file .fbx to be exported )
    :param task_id:                 CADCONV task's id
    :return:
    """

    data = {'data': {'component': {'source_fullpathname': None,
                                   'destination_fullpathname': None,
                                   'name': None,
                                   'xml_attributes': None}}}
    # get current task's full data
    task_data = service.find_task_by_id(task_id)
    try:
        stepcode = service.find_pipeline_step_by_name(task_data['step']['name'])['short_name']
    except:
        print('create_json_for_pixyz: cannot find a proper pipelinestep for task ['+str(task_id)+']')
        return None
    # strip task['content'] otf its prefix ("%STEP_SHORTNAME%_") to get the real component's name
    if not task_data['content'].startswith(stepcode + '_'):
        print('create_json_for_pixyz: task\'s content ['+str(task_data['content'])+'] must start with a proper prefix ['+str((stepcode + '_'))+'], but it ain\'t  [' + str(task_id) + ']')
        return None
    component_name = task_data['content'][len(stepcode + '_'):]
    data['data']['component']['name'] = component_name
    data['data']['component']['xml_attributes'] = task_data['sg_xmlattributes']

    # look for its upstream tasks of type 'CREOB' to get a proper .step file
    if not task_data['upstream_tasks']:
        print('create_json_for_pixyz: cannot find any upstream tasks at all!! [' + str(task_id) + ']')
        return None
    upstreams = [x['id'] for x in task_data['upstream_tasks']]
    creob_task = None
    for uptask_id in upstreams:
        uptask_data = service.find_task_by_id(uptask_id)
        if uptask_data['step']['name'] != 'Variant CAD': continue
        creob_task = uptask_data
    if not creob_task:
        print('create_json_for_pixyz: cannot find an upstream task of type CREOB!! [' + str(task_id) + ']')
        return None

    # get its last version
    versions = service.find_versions_by_task_id(creob_task['id'])
    if not versions:
        print('create_json_for_pixyz: upstream task of type CREOB ['+str(creob_task['content'])+'] doesn\'t have any version  [' + str(task_id) + ']')
        return None
    last_version = sorted(versions, key=lambda i: i['sg_versionnumber'])[-1]
    version_full_path = os.path.normpath(os.path.join(last_version['sg_fullpath'], 'SCENE'))
    if not os.path.exists(version_full_path):
        version_full_path = version_full_path.replace(r'\share', r'z:')
        if not os.path.exists(version_full_path):
            print('create_json_for_pixyz: no such folder exists:' + str(version_full_path))
            return None
    files_in_version = os.listdir(version_full_path)
    if not files_in_version:
        print('create_json_for_pixyz: no files exist in such folder:'+str(version_full_path))
        return None
    try:
        step_filename = [x for x in files_in_version if os.path.splitext(x)[0] == component_name][0]
    except:
        print('create_json_for_pixyz: couldn\'t find any file named :' + str(component_name))
        return None

    # must now get the sandbox in which the resulting FBX is going to be stored

    destination_fullpathname = os.path.normpath(os.path.join(version_full_path, step_filename)).replace('.stp','.fbx')

    data = {'data': {'component': {'destination_fullpathname': destination_fullpathname,
                                   'name': component_name,
                                   'step_filename': os.path.normpath(os.path.join(version_full_path, step_filename)),
                                   'xml_attributes': json.loads(task_data['sg_xmlattributes'])}}}


    return json.dumps(data)
#json_for_pixyz = create_json_for_pixyz()
#with open(r'\\master\CLIENTI\Luxottica\P190207_Luxottica_Pipeline\05_ExecutiveDocuments\03_Technical&Functional\COMMON\s.villa\temp_lux\json_for_pixyz.json', 'w') as f:
#    f.write(json_for_pixyz)
'''



#get the value off a schema of a category.attribute for a specific task
def get_schema_value(schema=None, category=None, attribute=None):
    '''
    Get the value off a schema of a category.attribute for a specific task
    :param schema:
    :param category:
    :param attribute:
    :return:
    '''
    category_data = [x for x in schema if x['code']==category]
    if not category_data: return  None
    attribute_data = [x for x in category_data[0]['sg_wd_attributes'] if x['code']==attribute]
    if not attribute_data: return None
    if attribute_data[0]['sg_datatype']['name']=='uuid':
        values = {}
        for attribute in attribute_data[0]['sg_value'][0]['sg_wd_attributes']:
            values[attribute['code']] = attribute['sg_value']
        return {attribute_data[0]['sg_value'][0]['code']:values}
    return attribute_data[0]['sg_value']


# decorator for catching exception on methods
def safe_run(func):
    def func_wrapper(*args, **kwargs):
        try:
            return func(*args, **kwargs)
        except Exception as e:
            print('Exception: '+str(e))

            '''exc_type, exc_obj, tb = sys.exc_info()
            f = tb.tb_frame
            lineno = tb.tb_lineno
            filename = f.f_code.co_filename
            linecache.checkcache(filename)
            line = linecache.getline(filename, lineno, f.f_globals)
            print ('EXCEPTION IN ({}, LINE {} "{}"): {}'.format(filename, lineno, line.strip(), exc_obj))
            '''
            return None

    return func_wrapper
class BasePixyzBatch(BaseAction.BaseAction):

    def execute(self, _payload, _lane=None):
        print(self.__class__.__name__)
        print (_payload)
        pass
# import stp file
class import_scene(BasePixyzBatch):
    #@safe_run
    def execute(self, _payload, _lane=None):
        stp_filename = _payload['step_filename']
        core.resetSession()
        io.importScene(stp_filename)
        return
class repair_cad(BasePixyzBatch):
    #@safe_run
    def execute(self, _payload, _lane=None):
        repair_CAD_required = _payload['attributes']['repairCADRequired']
        if repair_CAD_required:
            all = [scene.getRoot()]
            algo.repairCAD(all, _payload['attributes']['repairCADTolerance'], True)
        return
class assemble_cad(BasePixyzBatch):
    #@safe_run
    def execute(self, _payload, _lane=None):
        assemble_cad_required = _payload['attributes']['assembleCADRequired']
        if assemble_cad_required:
            all = [scene.getRoot()]
            algo.assembleCAD(all, _payload['attributes']['assembleCADTolerance'], True)
        return
class tessellate(BasePixyzBatch):
    #@safe_run
    def execute(self, _payload, _lane=None):
        tessellate_required = _payload['attributes']['tessellateRequired']
        current_preset = _payload['attributes']['tesselation_preset']
        if tessellate_required:
            all = [scene.getRoot()]
            algo.tessellate(occurrences=all,  #
                            maxSag=current_preset['maxSag'],  # 0.0020000
                            maxLength=current_preset['maxLength'],  # 10.000000
                            maxAngle=current_preset['maxAngle'],  # 12.000000
                            createNormals=current_preset['createNormals'],  # True
                            uvMode=current_preset['uvMode'],  # 2
                            uvChannel=current_preset['uvChannel'],  # 0
                            uvPadding=current_preset['uvPadding'],  # 0.000000
                            createTangents=current_preset['createTangents'],  # True
                            createFreeEdges=current_preset['createFreeEdges'],  # False
                            keepBRepShape=current_preset['keepBRepShape'],  # True
                            overrideExistingTessellation=current_preset['overrideExistingTessellation'])  # True
        return
class repair_mesh(BasePixyzBatch):
    #@safe_run
    def execute(self, _payload, _lane=None):
        repair_mesh_required = _payload['attributes']['repairMeshRequired']
        if repair_mesh_required:
            all = [scene.getRoot()]
            algo.repairMesh(all, _payload['attributes']['repairMeshTolerance'], True, True)
        return
class mapUV_on_mbb(BasePixyzBatch):
    #@safe_run
    def execute(self, _payload, _lane=None):
        mapUv_on_MBB_required = _payload['attributes']['mapUvOnMBBRequired']
        if mapUv_on_MBB_required:
            all = [scene.getRoot()]
            algo.mapUvOnMBB(all, False, _payload['attributes']['mapUvOnMBBUv3dSize'], 0, True)
        return
class repack_UV_required(BasePixyzBatch):
    #@safe_run
    def execute(self, _payload, _lane=None):
        repack_uv_required = _payload['attributes']['repackUVRequired']
        if repack_uv_required:
            all = [scene.getRoot()]
            algo.repackUV(all, 0, True, 2048, 2, False, 3, True)
        return
class smart_Orient_Required(BasePixyzBatch):
    #@safe_run
    def execute(self, _payload, _lane=None):
        smart_orient_required = _payload['attributes']['smartOrientRequired']
        if smart_orient_required:
            all = [scene.getRoot()]
            algo.smartOrient(all, 100.000000, 1.000000, 64, 0, True)
        return
class export_scene(BasePixyzBatch):
    #@safe_run
    def execute(self, _payload, _lane=None):
        export_filename = _payload['exportFullFilename']
        io.exportScene( export_filename)
        return


class launch_conversion(BasePixyzBatch):
    #@safe_run
    def execute(self, _payload, _lane=None):
        '''
        _payload must be like: _payload = {'data':{'component':{'source_fullpathname':'', 'destination_fullpathname':'', 'name':'', 'xml_attributes':''},
                                                    }}
        :param _payload:
        :param _lane:
        :return:
        '''
        data = _payload['data']

        pixyz_data = {'attributes':{}}
        pixyz_data['step_filename'] = data['component']['step_filename']
        for attrib in ['repairCADRequired','repairCADTolerance','assembleCADRequired', 'assembleCADTolerance',
                       'tessellateRequired','tesselation_preset', 'repairMeshRequired', 'repairMeshTolerance',
                       'mapUvOnMBBRequired','mapUvOnMBBUv3dSize', 'repackUVRequired', 'smartOrientRequired']:
            #pixyz_data['attributes'][attrib] = schema.get_schema_value(data['component']['xml_attributes'], category='CADCONV', attribute=attrib)
            pixyz_data['attributes'][attrib] = get_schema_value(data['component']['xml_attributes'], category='CADCONV', attribute=attrib)
        pixyz_data['destination_fullpathname'] =  data['component']['destination_fullpathname']

        for element in [import_scene,repair_cad,assemble_cad,tessellate,repair_mesh,mapUV_on_mbb,repack_UV_required,smart_Orient_Required,export_scene]:
            elem = element()
            elem.execute(_payload=pixyz_data)


        return






json_for_pixyz_filename = sys.argv[1] #r'\\master\CLIENTI\Luxottica\P190207_Luxottica_Pipeline\05_ExecutiveDocuments\03_Technical&Functional\COMMON\s.villa\temp_lux\json_for_pixyz.json'
#json_for_pixyz_filename = r'\\master\CLIENTI\Luxottica\P190207_Luxottica_Pipeline\05_ExecutiveDocuments\03_Technical&Functional\COMMON\s.villa\temp_lux\json_for_pixyz.json'

with open(json_for_pixyz_filename) as f:
  json_for_pixyz = json.load(f)

pixyz = launch_conversion()
data = pixyz.execute(json_for_pixyz)



