# Calculated the required re-render time for frames on the farm based on already rendered jobs and selected clients

client_count = rr.clientAll_count()
job_count = rr.jobSelected_count()
clients_selected = 0  # TODO: Needs a proper value to be used

if client_count == 0 or job_count == 0:
    rrGlobal.messageBox(rrGlobal.logLvL.info, "Please select job(s) and client(s) for the clculation")

# PS per client = Sum of client PS / number of clients 
PS_per_Client = 0
for ic in range(client_count):
    loop_client = rr.clientAll_get(ic)
    if (loop_client.isSelected()):
        PS_per_Client = PS_per_Client + loop_client.hw.PS
PS_per_Client = PS_per_Client / client_count

# Calculate average PS*s per frame = total PS of all selected jobs devided by the sum of their frames
total_PS_s = 0
total_frames = 0
for i in range(job_count):
    selected_job = rr.jobSelected_get(i)
    total_PS_s = total_PS_s + selected_job.infoRenderTimeSum_PS
    total_frames = total_frames + selected_job.infoTotal_FramesReturned
PS_per_frame= total_PS_s / total_frames

#TODO:
#Show UI dialog to edit number of frames, Client count, Client PS
frames_to_render = total_frames
# PS_per_Client = PS_per_Client
# client_count = client_count

res_time_sec = frames_to_render * PS_per_frame / PS_per_Client / client_count
res_time_sec = int(res_time_sec)
res_time_str = f"{res_time_sec // 60 // 60 // 24}d " \
               f"{res_time_sec // 60 // 60 % 24}h " \
               f"{res_time_sec // 60 % 60}m"

explanation = " (on average)" if client_count > 1 else ""

rrGlobal.messageBox(
    rrGlobal.logLvL.info,
    f"Re-rendering of {frames_to_render} frames\n"
    f"on {client_count} client(s) with {PS_per_Client}PS{explanation}\n"
    f" takes {res_time_str}."
    ,"","", False, 0)




