import sys
import os
import shutil

mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)

from rr_python_utils.load_rrlib import rrLib  # module libpyRR3 for python 3, libpyRR2 for python 2
import rr_python_utils.connection as rr_connect


def get_job_from_id(job_id, user_name=None):
    tcp = rr_connect.server_connect(user_name=user_name)

    if not tcp.jobList_GetInfo(job_id):
        print("Error jobList_GetInfo: " + tcp.errorMessage())
        return

    return tcp.jobs.getJobSend(job_id)


def print_job_info(job_data):
    print("Scene Name: " + job_data.sceneName)
    print("User Name: " + job_data.userName)
    print("Frames: {0}".format(job_data.framesTotal))


if __name__ == "__main__":
    import argparse
    parser = argparse.ArgumentParser()
    parser.add_argument("-jid")
    parser.add_argument("-authStr")
    args = parser.parse_args()

    job_data = get_job_from_id(int(args.jid), user_name=args.authStr)
    print_job_info(job_data)
