
######################################################################
#
# Name:  Copy Scene on Submission
# Author:  Royal Render, Paolo Acampora, Binary Alchemy
# Version: 
# Description: 
#   Copy of the scene to a new file and submit to the render farm
#
# Copyright (c) Holger Schoenberger - Binary Alchemy
######################################################################


import datetime
import os
import shutil


copied = {}  # scenes that have been copied already

for i in range(rr.jobAll_count()):
    job = rr.jobAll_get(i)
    
    if (str(job.sceneName).find("<FN")>0):
        continue

    if not os.path.exists(job.sceneName):
        continue

    try:
        sc_copy = copied[job.sceneName]
    except KeyError:
        now_time = datetime.datetime.now()
        scene_path, scene_name = os.path.split(job.sceneName)
        

        # copy to zz_<Scenefile>_<month><day><hour><sec>
        scene_name, scene_ext = os.path.splitext(scene_name)
        cp_name = "zz_{0}_{1:02d}{2:02d}{3:02d}{4:02d}{5}".format(scene_name,
                                                                   now_time.month, now_time.day,
                                                                   now_time.hour, now_time.second,
                                                                   scene_ext)
        sc_copy = os.path.join(scene_path, cp_name)
        shutil.copyfile(job.sceneName, sc_copy)
        copied[job.sceneName] = sc_copy

    job.sceneName = sc_copy
    rr.jobAll_set(i, job)
