

import os
import sys

mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)

import rr_python_utils.connection as rr_connect

if rr_connect.rrLib.getModuleVersionMajor()<9:
   raise Exception("Incompatible RR Version" )

def get_client_groups():
    tcp = rr_connect.server_connect()
    client_group_list = tcp.clientGetGroups()

    if client_group_list.count <= 0:
        print("Error getting client groups: " + tcp.errorMessage())
        return

    if sys.version_info.major < 3:
        RANGE_FUNC = xrange
    else:
        RANGE_FUNC = range

    groups_count = client_group_list.count
    print("Found {0} client groups".format(groups_count))

    for i in RANGE_FUNC(groups_count):
        cl_group = client_group_list.clientGroup(i)
        print("\t{0} - Number of Clients: {0}".format(cl_group.getName(), cl_group.count()))


if __name__ == "__main__":
    get_client_groups()
    print("\n\n--- DONE ---\n\n")
