#include "rrSceneParserXSI.h"

#include <QFile> 
#include <QDomDocument>
#include <QStringList>
#include "../../shared_SDK/RR_DataTypes_jobs0__Classes_SDK.h"
#include "../../sharedLib/RR_files_SDK.h"

QString rrGetEnvironmentVariable_local(const QString &name)
{
	QString ret;
#ifdef RR_OS_WIN

	if (name.compare("ProgramFiles",Qt::CaseInsensitive)==0) {
		QString nameTest;
		nameTest="ProgramW6432";
		wchar_t *pValue;
		size_t len;
		int err = _wdupenv_s( &pValue, &len, (wchar_t*) nameTest.utf16() );
		if ( err==0 && (len>0)) {
			ret= QString::fromWCharArray(pValue,(int) len-1);
			free( pValue );
			return ret;
		}
	}

	wchar_t *pValue;
	size_t len;
	int err = _wdupenv_s( &pValue, &len, (wchar_t*) name.utf16() );
	if ( err==0 ) {
		ret= QString::fromWCharArray(pValue,(int) len-1);
		free( pValue );
	} 
#else
	char * buffer;
	buffer= getenv(name.toLatin1().data());
	if (buffer) ret=QString::fromLatin1(buffer);
#endif
	return ret;
}


DllExport_plugin int pInfo(rrP::_dataPARS_Info * const data)
{
	data->RRVersion= rrVersion;
	data->QTVersion= qVersion();
    data->MinorID=rrP::MinorID_PARS;

    //Human readable informations about the plugin:
    data->pluginName=       "Softimage";
    data->pluginAuthor=     "RR, Holger Schoenberger";
    data->pluginVersion=    "1.0";

    //Check if the data structure is compatible:
    if (data->StructureID!=rrP::StructureID_PARS) {
        data->StructureID=rrP::StructureID_PARS;
        return rrP::rRRDataVersionConflict;
    } else {
        data->StructureID=rrP::StructureID_PARS;
    }
	data->setDebugCompile();
	data->supportedFileExt= "*.scntoc;";

	return rrP::rSuccessful;
}


void replaceXSIVariables(QString &str)
{
	str.replace("[Project Path]","<Database>",Qt::CaseInsensitive);
	str.replace("[Project]","<DatabaseName>",Qt::CaseInsensitive);
	str.replace("[Scene]","<SceneFile>",Qt::CaseInsensitive);
	str.replace("[Date]","<Date>",Qt::CaseInsensitive);
	str.replace("[User]","<User>",Qt::CaseInsensitive);
	str.replace("[Host]","<Host>",Qt::CaseInsensitive);
	str.replace("[Pass]","<Layer>",Qt::CaseInsensitive);
	str.replace("[Camera]","<Camera_no.>",Qt::CaseInsensitive);
	str.replace("[Channel]","<Channel>",Qt::CaseInsensitive);
	while (str.contains("[env ",Qt::CaseInsensitive)) {
		int s,e;
		s=str.indexOf("[env ",0,Qt::CaseInsensitive);
		e=str.indexOf("]",s,Qt::CaseInsensitive);
		QString env=str.mid(s,e-s+1);
		str.remove(s,e-s+1);
		env.remove(0,4);
		env.remove(env.length()-1,1);
		env=env.trimmed();
		env=rrGetEnvironmentVariable_local(env);
		str.insert(s,env);
	}

	//remove unsupported variables
	str.replace("[","",Qt::CaseInsensitive);
	str.replace("]","",Qt::CaseInsensitive);
}


QString getXMLChildString(const QString &childname,const QDomElement &docElem,const QString &defaultValue=QString())
{
	QDomElement docElemC= docElem.firstChildElement(childname);
	if ((!docElemC.isNull()) && (!docElemC.text().isEmpty()))
		return docElemC.text();
	else return defaultValue;
}


bool getXMLChildBool(const QString &childname,const QDomElement &docElem,const bool &defaultValue=false)
{
	QDomElement docElemC= docElem.firstChildElement(childname);
	if (!docElemC.isNull())				
		return docElemC.text()=="1";
	else return defaultValue;
}


int getXMLChildInt(const QString &childname,const QDomElement &docElem,const int &defaultValue=0)
{
	QDomElement docElemC= docElem.firstChildElement(childname);
	if (!docElemC.isNull())	{
		bool ok;
		int v;
		v= docElemC.text().toInt(&ok);
		if (ok)  return v;
		else return defaultValue;
	}
	else return defaultValue;
}



DllExport_plugin int pLoadSceneFile(rrP::_dataPARS_LoadSceneFile * const data)
{
	try 
	{

	//check for version conflict RRender<>This plugin
	if (!data->jobs->isVersionSupported()) return rrP::rRRDataVersionConflict; 

	//As the Submitter has loaded a .scntoc file, we have to replace check for the "real" .scn scene file.
	QString RealSceneFileName;
	RealSceneFileName=*(data->fileName);
	RealSceneFileName.replace(".scntoc",".scn",Qt::CaseInsensitive);
	QFile RealscnFile(RealSceneFileName);
	if (!RealscnFile.exists()) return rrP::rFileNotFound; 



	QFile scnFile(*(data->fileName));
	//Load XML file
	QDomDocument document;
	if (!document.setContent(&scnFile)) {
		scnFile.close();
		return rrP::rFileFailedToOpen;
	}
	scnFile.close();
	QDomElement docElem1 = document.firstChildElement("xsi_file");
	if (docElem1.isNull()) return rrP::rUnsupportedFormat;


	//Get XSI version
	QString s1,s2,s3;
	s2="";
	s1=docElem1.attribute("xsi_version");
	if (s1.contains('.')) {
		s2=s1.right(s1.size()-1-s1.indexOf('.'));
		s1.truncate(s1.indexOf('.'));
		if (s2.contains('.')) {
			s3=s2.right(s2.size()-1-s2.indexOf('.'));
			s2.truncate(s2.indexOf('.'));
			if (s3.contains('.')) {
				s3.truncate(s3.indexOf('.'));
			}
		}
	}
	
	int glAppVersMayor;
	QString glAppVersMinor;
	glAppVersMayor=s1.toInt();
	glAppVersMinor=s2;

	if (glAppVersMayor>=8) glAppVersMayor+=2002;
	bool isXSI5=glAppVersMayor<6;
	if ((glAppVersMayor==2010) && (s3.toInt()>248)) glAppVersMinor="1";
	


	docElem1 = docElem1.firstChildElement("Passes");
	if (docElem1.isNull()) return rrP::rUnsupportedFormat;
	QDomElement docElemP,docElemC,docElemF;

	//Get XSI's global settings
	QString glRenderer, glOutputDir, glFrameset;
	int glImageWidth=0,glImageHeight=0, glSeqStart=1, glSeqEnd=0, glSeqStep=1, glFramePadding=3, glFrameRangeSource=0;
	bool glFieldEnable=false;
	if (!isXSI5) {
		docElemP=docElem1.firstChildElement("RenderOptions");
		if (docElemP.isNull()) return rrP::rDataError;
		glRenderer		=getXMLChildString("Renderer",docElemP,"Mental Ray");
		glOutputDir		=getXMLChildString("OutputDir",docElemP,"[Project Path]/Render_Pictures/");
		if (glOutputDir.isEmpty()) glOutputDir="[Project Path]/Render_Pictures/";
		glOutputDir=rrConvertPDToOS(glOutputDir);
		replaceXSIVariables(glOutputDir);
		if (glOutputDir.at(glOutputDir.size()-1)!=PD) glOutputDir+=PD;

		glFramePadding	=getXMLChildInt("FramePadding",docElemP,4);
		glImageWidth	=getXMLChildInt("ImageWidth",docElemP,800);
		glImageHeight	=getXMLChildInt("ImageHeight",docElemP,800);
		glFrameRangeSource	=getXMLChildInt("FrameRangeSource",docElemP,0);
		glSeqStart		=getXMLChildInt("FrameStart",docElemP,1);
		glSeqEnd		=getXMLChildInt("FrameEnd",docElemP,100);
		glSeqStep		=getXMLChildInt("FrameStep",docElemP,1);
		glFieldEnable	=getXMLChildBool("FieldEnable",docElemP,false);
		glFieldEnable	=(glFieldEnable && (!getXMLChildInt("FieldInterleave",docElemP)));
        glFrameset		=getXMLChildString("FrameSet",docElemP,"");
	}

	

	//Now get the passes and add jobs
    rrJ::_JobBasics_largePath *job;
	int  locFrameRangeSource;
	bool FieldOverride;
	bool locFields;


	data->jobs->m_maxJobs=0;
	docElemP=docElem1.firstChildElement("Pass");
	while (!docElemP.isNull()) {
		data->jobs->m_maxJobs++;
		data->jobs->setArraySize(data->jobs->m_maxJobs);
		job= data->jobs->at(data->jobs->m_maxJobs -1);
		if (!job) return rrP::rMemError;
		job->rrClearBasics();

		job->m_layer=docElemP.attribute("name");

		if (isXSI5) {
			job->m_soft.rendererName	=getXMLChildString("RenderEngine",docElemP,glRenderer);
			job->m_requiredLicenses=job->m_soft.rendererName;
			job->m_camera				=getXMLChildString("PassCamera",docElemP);
			job->m_imageWidth			=getXMLChildInt("CameraXRes",docElemP);
			job->m_imageHeight		=getXMLChildInt("CameraYRes",docElemP);
			job->m_seqStart			=getXMLChildInt("StartFrame",docElemP);
			job->m_seqEnd				=getXMLChildInt("EndFrame",docElemP);
			job->m_seqStep			=getXMLChildInt("Step",docElemP);
		} else {
			job->m_soft.rendererName	=getXMLChildString("Renderer",docElemP,glRenderer);
			job->m_requiredLicenses=job->m_soft.rendererName;
			job->m_camera				=getXMLChildString("Camera",docElemP);
			//if (job->Camera.contains('.')) job->Camera.remove(0,job->Camera.indexOf('.')+1);
			//if (job->Camera.contains('.')) job->Camera.remove(0,job->Camera.indexOf('.')+1);
			job->m_imageWidth			=getXMLChildInt("ImageWidth",docElemP);
			job->m_imageHeight		=getXMLChildInt("ImageHeight",docElemP);
			int ImageFormatOverride =getXMLChildInt("ImageFormatOverride",docElemP);
			if (ImageFormatOverride==0) {
				job->m_imageWidth=glImageWidth;
				job->m_imageHeight=glImageHeight;
			}

			FieldOverride	=getXMLChildBool("FieldOverride",docElemP);
			if (FieldOverride) {
				locFields	=getXMLChildBool("FieldEnable",docElemP);
				locFields	=(locFields && (!getXMLChildInt("FieldInterleave",docElemP)));
			} else {
				locFields=glFieldEnable;
			}
			if (locFields) {
				job->m_imageMulti=2;
				job->m_imageMultiAdd[0]=".1";
				job->m_imageMultiAdd[1]=".2";
			}
			int bufferFound=0;

			bool Fenabled;
			QString Fname, FOutputFile, FOutputDir, FFormat;
			int FFramePadding;
			int FFrameOffset;
			

			docElemC= docElemP.firstChildElement("FrameBuffers");
			if (docElemC.isNull()) return rrP::rUnsupportedFormat;
			docElemF= docElemC.firstChildElement("FrameBuffer");
			while (!docElemF.isNull()) {
				Fenabled=false;
				Fname=docElemF.attribute("name");
				FFrameOffset=0;
				FOutputDir="";
				FFramePadding=glFramePadding;

				Fenabled		=getXMLChildBool("Enabled",docElemF);
				FOutputFile		=getXMLChildString("Filename",docElemF);
				FFormat			=getXMLChildString("Format",docElemF,"pic");

				FOutputFile.replace("[Framebuffer]" , Fname,Qt::CaseInsensitive);
				FOutputFile.replace("[Channel]" , Fname,Qt::CaseInsensitive);
				FOutputFile=rrConvertPDToOS(FOutputFile);
				FFormat="."+FFormat;
				if (FOutputFile.contains("[Frame ")) {
					int ps,pe;
					ps= FOutputFile.indexOf("[Frame ");
					pe= FOutputFile.indexOf("]",ps);
					if ((ps>=0) && (pe>=0)) {
						s1=FOutputFile.mid(ps+6,pe-6-ps);
						s1=s1.trimmed();
						FFormat = FOutputFile.right(FOutputFile.size()-1-pe)+ FFormat;
						FOutputFile.truncate(ps);

						if (s1.contains('#')) {
							ps= s1.indexOf('#');
							if (ps+1 < s1.size())  {
								pe=ps+2;
								while ((pe<s1.size()-1) && (s1.at(pe+1)!=' ')) pe++;
								s2=s1.mid(ps+1,pe-ps);
								bool ok;
								FFramePadding=s2.toInt(&ok);
								if (!ok) FFramePadding = glFramePadding;
							}
						}
						if (s1.contains('+')) {
							ps= s1.indexOf('+');
							if (ps+1 < s1.size())  {
								pe=ps+2;
								while ((pe<s1.size()-1) && (s1.at(pe+1)!=' ')) pe++;
								s2=s1.mid(ps+1,pe-ps);
								bool ok;
								FFrameOffset=s2.toInt(&ok);
								if (!ok) FFrameOffset = 0;
							}
						}
						if (s1.contains('-')) {
							ps= s1.indexOf('-');
							if (ps+1 < s1.size())  {
								pe=ps+2;
								while ((pe<s1.size()-1) && (s1.at(pe+1)!=' ')) pe++;
								s2=s1.mid(ps+1,pe-ps);
								bool ok;
                                FFrameOffset= -s2.toInt(&ok);
								if (!ok) FFrameOffset = 0;
							}
						}
					}
				} else {
					FOutputFile.replace("[Frame]","#");

				}
				replaceXSIVariables(FOutputFile);

				if (FOutputFile.contains('#')) {
					FFramePadding =FOutputFile.count('#');
					FFormat = FOutputFile.right(FOutputFile.size()-1-FOutputFile.lastIndexOf('#'))+ FFormat;
					FOutputFile.truncate(FOutputFile.indexOf('#'));
				} 
				if (FOutputFile.contains(PD)) { 
					FOutputDir  = FOutputFile.left (FOutputFile.lastIndexOf(PD)+1);
					FOutputFile = FOutputFile.right(FOutputFile.size()-FOutputFile.lastIndexOf(PD)-1);
				} 
				if (isRelativePath(FOutputDir)) FOutputDir=glOutputDir+FOutputDir;
				
				if (FOutputFile.isEmpty()) FOutputFile="<Layer>_"+Fname;
				if (FOutputFile.at(FOutputFile.size()-1)!='.') FOutputFile+='.';

				if (Fenabled) {
					bufferFound++;

					if (bufferFound==1) {
						job->m_imageDir=FOutputDir;
						job->m_imageFileName=FOutputFile;
						job->m_imageExtension=FFormat;
						job->m_imageFramePadding=FFramePadding;
						job->m_seqFileOffset=FFrameOffset;
					} else if (bufferFound<rrJ::MaxImageChannels) {
	//					job->ImageChannels[bufferFound-1].Dir=FOutputDir;
						job->m_imageChannels[bufferFound-1].fileName=FOutputDir+FOutputFile;
						job->m_imageChannels[bufferFound-1].extension=FFormat;
					}
				}
				docElemF=docElemF.nextSiblingElement("FrameBuffer");
			} //loop framebuffers
			if (bufferFound==0) {
				data->jobs->m_maxJobs--;
                docElemP=docElemP.nextSiblingElement("Pass");
				continue;
			}

			QString frameset="";
			locFrameRangeSource		=getXMLChildInt("FrameRangeSource",docElemP);
			switch (locFrameRangeSource) {
				case 1:
					frameset=getXMLChildString("FrameSet",docElemP);
					//no break;
				case 0:
				case 2:
					job->m_seqStart	=getXMLChildInt("FrameStart",docElemP);
					job->m_seqEnd		=getXMLChildInt("FrameEnd",docElemP);
					job->m_seqStep	=getXMLChildInt("FrameStep",docElemP);
					break;
				case 3:
					job->m_seqStart=glSeqStart;
					job->m_seqEnd  =glSeqEnd;
					job->m_seqStep =glSeqStep;
					if (glFrameRangeSource==1) frameset=glFrameset;
					break;
			}

			if (!frameset.isEmpty()) {
				QStringList sets=frameset.split(',');
				for (int i=0; i<sets.count(); i++) {
					QString se=sets.at(i).trimmed();
					if (se.isEmpty()) continue;
					if (i>0) {
						if (!data->jobs->getNewJob(job)) return rrP::rMemError;
                        rrJ::_JobBasics_largePath * jobOld = NULL;
						jobOld=data->jobs->at(data->jobs->m_maxJobs -2);
						*job= *jobOld;
					}
					if (se.contains('-')) {
						job->m_seqStart=se.left(se.indexOf('-')).toLong();
						se=se.remove(0,se.indexOf('-')+1);
						job->m_seqEnd=se.toLong();
						job->m_seqStep=1;
					} else {
						job->m_seqStart=se.toLong();
						job->m_seqEnd=job->m_seqStart;
						job->m_seqStep=1;
					}
				}
			}//Frameset

		} //xsi60
		


		docElemP=docElemP.nextSiblingElement("Pass");
	}
	
	

	QString DatabaseDir;
	DatabaseDir=rrGetDirName(RealSceneFileName);
	if (!rrDirectoryExists(DatabaseDir+"system")) {
		DatabaseDir=rrGetDirName(DatabaseDir);
		if (!rrDirectoryExists(DatabaseDir+"system")) {
			DatabaseDir=rrGetDirName(DatabaseDir);
			if (!rrDirectoryExists(DatabaseDir+"system")) {
				DatabaseDir=rrGetDirName(DatabaseDir);
				if (!rrDirectoryExists(DatabaseDir+"system")) {
					DatabaseDir=rrGetDirName(DatabaseDir);
					if (!rrDirectoryExists(DatabaseDir+"system")) {
						QString scnFol=PDs+QString("Scenes")+PDs;
						DatabaseDir=rrGetDirName(RealSceneFileName);
						if (DatabaseDir.contains(scnFol,Qt::CaseInsensitive)) {
							DatabaseDir.truncate(DatabaseDir.lastIndexOf(scnFol,-1,Qt::CaseInsensitive)+1);
						} else if (DatabaseDir.contains(PD)) {
							DatabaseDir.truncate(DatabaseDir.lastIndexOf(PD)+1);
						}
					}
				}
			}
		}
	}



	for (int j=0; j<data->jobs->m_maxJobs;j++) {
		job= data->jobs->at(j);
		if (!job) return rrP::rMemError;
		job->m_soft.name="Softimage";
		job->m_soft.version=glAppVersMayor;
		job->m_soft.setVersionMinor(glAppVersMinor);
		job->m_sceneName=RealSceneFileName;
		job->m_sceneDatabaseDir=DatabaseDir;
		job->m_uiIsChecked=true;
		job->m_imagePreNumberLetter='.';
		
		job->splitImageFileInto_DirFileExt();
	}



	return rrP::rSuccessful;
	}
	catch (...)
	{
		return rrP::rCError;

	}
}


