import rrGlobal
import sys

'''import  rrSG
import  sys
modPath=rrGlobal.rrModPyrrPath()
sys.path.append(modPath)
print("added module path "+modPath)
import libpyRR2 as rr'''

class RoyalSGStatParser(object):
    def __init__(self, *args):
        self._debug = False

        self.sgid = None
        self.status = None
        self.av_mem_usage = None
        self.av_render_time = None

        self.parse(args)
        self.error = ""
        self.success = self._is_valid()
    
    def _is_valid(self):
        if self._debug:
            print("sgid", self.sgid)
            print("avMemUsage", self.av_mem_usage)
            print("avRenderTime", self.av_render_time)
            print("status", self.status)

        if not self.sgid:
            self.error = "Missing argument: -sgid (Shotgun ID)"
            return False
        if not self.status:
            self.error = "Missing argument: -status (Render Entity State)"
            return False
        if not self.av_mem_usage:
            self.error = "Missing argument: -avMemUsage (Average Memory Usage)"
            return False
        if not self.av_render_time:
            self.error = "Missing argument: -avRenderTime (Average Render Time)"
            return False

        return True

    def parse(self, args):
        args = list(args)
        if not args:
            raise Exception("no arguments given: -sgdi SHOTGUN_ID -status RENDER_STATUS -avMemUsage AV_MEM_USAGE -avRenderTime AV_RENDER_TIME")

        while args:
            arg = args.pop(0)
            if arg == "-debug":
                self._debug = True
                continue

            if args and arg == "-sgid":
                self.sgid = args.pop(0)
                continue

            if args and arg == "-status":
                self.status = args.pop(0)
                continue

            if args and arg == "-avMemUsage":
                self.av_mem_usage = args.pop(0)
                continue

            if args and arg == "-avRenderTime":
                self.av_render_time = args.pop(0)
                continue


class RRsgParseException(Exception):
    pass


def updateStatsCmd():
    print("Update render stats in shotgun")
    
    parser = RoyalSGStatParser(*sys.argv)
    if not parser.success:
        raise RRsgParseException(parser.error)
            
    shreID = parser.sgid
    if (not shreID or (shreID=="none")):
        print("Job has no Shotgun ID.")
        return
    
    import royalRifle
    global rRifle
    rRifle=royalRifle.RoyalRifle()
    renderEntity={}

    #renderEntity_old= rRifle._findRenderEntity(int(args.sgid))
    #print("\t\t renderEntity1 : %s" % renderEntity_old)
    renderEntity['sg_average_render_time'] = parser.av_render_time
    memFloat = float(parser.av_mem_usage)
    renderEntity['sg_average_memory_usage'] = memFloat
    rRifle._updateRenderEntity(int(parser.sgid), renderEntity)
    rRifle.setRenderEntityState(int(parser.sgid), parser.status)


updateStatsCmd()
