
import os
import platform
import sys

mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)

from rr_python_utils.load_rrdata import rrData


def search_group_by_name(group_name, group_list):
    """Return index of group matching `group_name` among those contained in ˆgroup_listˆ.
    Return -1 in case no match is found"""
    for grp_idx in range(group_list.count):
        grp = group_list.clientGroup(grp_idx)

        if grp.getName().lower() == group_name.lower():
            found_idx = grp_idx
            print("Found existing group '{0}' at index {1}".format(group_name, found_idx))

            return found_idx

    return -1


def add_client_to_group(group_name, add_client):
    group_cfg_filename = rrData.getRRFolder_cfgUser()
    if not group_cfg_filename:
        print("ERROR: RR folder not found.")
        return

    group_cfg_filename = group_cfg_filename + "clientgroups.ini"
    print("RR group cfg file: " + group_cfg_filename)

    group_list = rrData._ClientGroupList()
    ret_success = group_list.loadFromFile(group_cfg_filename)
    if not ret_success:
        print("ERROR: Unable to load file '{0}'. {1}".format(group_cfg_filename, group_list.getError()))
        return

    print("Group list loaded ({0} groups)".format(group_list.count))
    grp_idx = search_group_by_name(group_name, group_list)
    if grp_idx >= 0:
        group = group_list.clientGroup(grp_idx)
    elif group_list.count < group_list.clientGroupsMax():
        print("Creating new group '{0}'".format(group_name))
        group = rrData._ClientGroup()
        group.setName(group_name)
        grp_idx = group_list.count
        group_list.count += 1
    else:
        print("ERROR: Group '{0}' not found and group limit reached.".format(group_name))
        return

    machine_name = platform.node()
    if add_client:
        print("Adding  '{0}' to group '{1}'.".format(machine_name, group_name))
        group.addClient(machine_name)
    else:
        print("Removing  '{0}' from group '{1}'.".format(machine_name, group_name))
        group.removeClient(machine_name)

    group_list.clientGroupSet(grp_idx, group)
    ret_success = group_list.saveToFile(group_cfg_filename)
    if not ret_success:
        print("ERROR: Unable to save file '{0}'. {1}".format(group_cfg_filename, group_list.getError()))
        return

    print("Group file was saved.")


if __name__ == '__main__':
    import argparse

    parser = argparse.ArgumentParser(description="Add or remove current machine to a client group")
    parser.add_argument("-group")
    parser.add_argument("-addClient")
    args = parser.parse_args()

    if not args.group:
        print("ERROR: No group name specified")
        sys.exit()
    if not args.addClient:
        print("ERROR: No group add flag specified")
        sys.exit()

    add_client = None
    if any((args.addClient == "0", args.addClient.lower() == "false")):
        add_client = False
    elif any((args.addClient == "1", args.addClient.lower() == "true")):
        add_client = True

    if add_client == None:
        print("ERROR: Could not parse `-addClient` argument as a flag. Please use either 0 or `false` or 1 or `true`")
        sys.exit()

    add_client_to_group(args.group, add_client)
    print("\n\n--- DONE ---\n\n")
