#
#  This script reads the server daily stat file for the average frame time
#  of each project, user and render app and saves them into an excel file
#
# You need to execute this python script with rrPythonconsole
#
import os
import sys


mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)

from rr_python_utils.load_rrdata import rrData

from os import listdir
from os.path import isfile, join
import csv


exportFolder = rrGlobal.rrRootPath() + "inhouse/"


#Note: Please check your license via rrControl/help menu of you have access to the class rrTable
rrTableUser	= rrGlobal._rrTable();
rrTableProjects = rrGlobal._rrTable();
rrTableRenderApp = rrGlobal._rrTable();
rrTableUser.setHeader(0, "Date")		
rrTableProjects.setHeader(0, "Date")		
rrTableRenderApp.setHeader(0, "Date")		


serverDaily= rrData._dailyStats_data()
serverStatFolder=rrGlobal.rrRootPath()+"sub/stats/server/"
serverStatFileList = [f for f in listdir(serverStatFolder) if isfile(join(serverStatFolder, f))]
print (serverStatFolder+": "+str(len(serverStatFileList))+ " files found.")
row= 0
for statFile in serverStatFileList:
    if not serverDaily.loadFromFile(serverStatFolder+statFile,True):
        print(statFile+"| Error: "+serverDaily.getError())
    else:
        row= row+1
        rrTableUser.setDatetime(0,row,serverDaily.fileNameDate())
        rrTableProjects.setDatetime(0,row,serverDaily.fileNameDate())
        rrTableRenderApp.setDatetime(0,row,serverDaily.fileNameDate())
        
        userStat= serverDaily.singleStats(0)
        prjStat= serverDaily.singleStats(1)
        renderAppStat= serverDaily.singleStats(2)	
        print(serverDaily.fileNameDate().strftime('%Y.%m.%d')+"| "+str(len(userStat))+" users, "+str(len(prjStat))+" projects, "+str(len(renderAppStat))+" render apps  found.")
        for stat in userStat:
            maxUsage=0
            for t in range(0, stat.statCount()):
               if stat.stats(t).avFrameTime >maxUsage:
                   maxUsage= stat.stats(t).avFrameTime
                   #print(stat.stats(t).avFrameTime,stat.stats(t).PSneeded,stat.stats(t).maxGhzUsage,stat.stats(t).renderLicNeeded )
            rrTableUser.setIntByName(stat.name, row, maxUsage )
            
        for stat in prjStat:
            maxUsage=0
            for t in range(0, stat.statCount()):
               if stat.stats(t).avFrameTime >maxUsage:
                   maxUsage= stat.stats(t).avFrameTime
            rrTableProjects.setIntByName(stat.name, row, maxUsage )
        
        for stat in renderAppStat:
            maxUsage=0
            for t in range(0, stat.statCount()):
               if stat.stats(t).avFrameTime >maxUsage:
                   maxUsage= stat.stats(t).avFrameTime
            rrTableRenderApp.setIntByName(stat.name, row, maxUsage )
	    
	    
if not rrTableUser.saveAsCsv(exportFolder+"_globalstat_user.csv", False):
    print ("Error: Unable to save user table! "+rrTableUser.fileError())
if not rrTableProjects.saveAsCsv(exportFolder+"_globalstat_project.csv", False):
    print ("Error: Unable to save project table! "+rrTableProjects.fileError())
if not rrTableRenderApp.saveAsCsv(exportFolder+"_globalstat_renderapp.csv", False):
    print ("Error: Unable to save render app table! "+rrTableRenderApp.fileError())
	
	

print("Saved into folder "+exportFolder)
print("\n\n--- DONE ---\n\n")
