# Last change: %rrVersion%
# Copyright (c) Holger Schoenberger - Binary Alchemy


# This example script loads jobs of a specified project from the current rrServer queue and from the history database.
# It collects data from the custom client usage counter "Watt" (Can be used for anything beside real Watt as well)

import sys
import os
import shutil
import traceback
import tempfile
from datetime import datetime

mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)
    
    
from rr_python_utils.load_rrdata import rrData
if sys.version_info.major == 2:
    range = xrange

#-------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------
    

import logging
# TODO: final logging directory for Royal Render
_TEMP_DIR = tempfile.gettempdir()
_TEMP_NAME = "rrWattCounter.log"

# create logger
logger = logging.getLogger("rrS")
logger.setLevel(logging.DEBUG)
ch = logging.StreamHandler()
ch.setLevel(logging.DEBUG)

# create formatter and add it to the handlers
formatter = logging.Formatter("%(asctime)s %(name)s| %(levelname)s:  %(message)s", "%H:%M:%S")
ch.setFormatter(formatter)

# add the handlers to the logger
logger.addHandler(ch)


#-------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------

summed_Wh=0


logger.info("Checking history dabatase jobs")

dbFolder =  rrData.getRRFolder_historydb()
hdb= rrData._historyProjectLoader()
if not hdb.loadProjectList(dbFolder):
    logger.error(hdb.errorString())
    sys.exit(3)


for j in range(hdb.projectCount()):
    hdb.loadProject(j)
    for i in range(hdb.jobCount()):
        job= hdb.jobAt(i)

        if job.dateSend.year!=2021:
            continue
        
        if (job.infoRenderTimeSum_WattSec > 0):
            summed_Wh = summed_Wh +  (job.infoRenderTimeSum_WattSec /60/60 )    
            logger.debug("   " + job.IDstr()+"\t WattSec: "+str(job.infoRenderTimeSum_WattSec)  )
        else:
            #jobs rendered before this custom counter was available
            #infoRenderTimeSum_seconds was not available as well, so we use Ghz*h
            averageGhzPerMachine=100
            assumed_Wh = int(job.infoRenderTimeSum_Ghz_h * 400 / averageGhzPerMachine)  
            summed_Wh = summed_Wh +  assumed_Wh
            logger.debug("   " + job.ID2str()+"\t WattSec: "+str( assumed_Wh)+ " (ASSUMED) "  )        



logger.info("\n\nTotal wH of all jobs in 2021: "+str(summed_Wh) +"\nTotal kwH:  "+str(summed_Wh/1000)+"\n\n")

logger.info("\n\n--- DONE ---\n\n")
