
scriptVersion_str="rrSubmit 1.0.12"
exportAsXML= False



import sys
import os
import shutil
import traceback
import tempfile
from datetime import datetime
import logging

# create logger
logger = logging.getLogger("rrSubmit")
logger.setLevel(logging.DEBUG)
ch = logging.StreamHandler()
ch.setLevel(logging.DEBUG)
# create formatter and add it to the handlers
formatter = logging.Formatter("%(asctime)s %(name)s| %(levelname)s:  %(message)s", "%H:%M:%S")
ch.setFormatter(formatter)
# add the handlers to the logger
logger.addHandler(ch)


    
mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)

from rr_python_utils.load_rrsubmit import rrSubmitLib  # module for python 3.7, 3.9 or 2.7
import rrJob

rrSubmitter= rrSubmitLib.Submitter()

rrSubmitter.deleteAllJobs()
renderApp= rrJob._RenderAppBasic() #somehow this does not work within Houdini?



#Example 1: create a Houdini job
renderApp.clear()
renderApp.name="Houdini"
renderApp.setVersionBoth("18.5.12")
renderApp.rendererName=""  

newJob= rrSubmitLib.createEmptyJob2("e:/3D/houdini/box_arnold.hipnc", scriptVersion_str)
newJob.layer= "/out/mantra1"
newJob.renderApp= renderApp
newJob.imageFileName= "e:/3D/houdini/renderOut/myRender.###.exr"
newJob.seqStart= 1
newJob.seqEnd=  100

#add/append rrSubmitter options
newJob.customDataAppend_Str("rrSubmitterParameter", " SeqDivMin=1~3 SeqDivMax=1~10")
newJob.customDataAppend_Str("rrSubmitterParameter", " Linearcolor=0~1")

#add a custom variable to the job
newJob.customDataSet_Str("CustomMyVar", "MyValue")

#set predefined custom vars that are not in 'customData'
newJob.customSeqName="010"
newJob.customShotName="189"
newJob.customVersionName="B4"
newJob.customSceneName="beautyrender" #replaces scene filename in rrControl table
newJob.customJobType="Playblast"

newJob.division="Playblast;Houdini"


envList= ""
envList= envList + "MyEnv=MyValue"  + "~~~"
envList= envList + "MoreEnv=MoreValue"  + "~~~"
newJob.customSet_Str("rrEnvList", envList )
#newJob.customDataSet_Str("AddCmdFlags", " aaaaaaaaaaaaa")

logger.debug("Add Job:  {}   {} start:{} end:{}".format(newJob.renderApp.rendererName,  newJob.layer, newJob.seqStart,  newJob.seqEnd))
rrSubmitter.addJob(newJob)


if False:
    #Example 2: create an commandline job
    renderApp.clear()
    renderApp.name="Execute"
    renderApp.rendererName="Once"  
    renderApp.setVersionBoth("1.0")

    newJob= rrSubmitLib.createEmptyJob2("C:/myPipeline/rez/rez-env", scriptVersion_str)
    newJob.customDataSet_Str("AddCmdFlags", " package package maya something")

    #set predefined custom vars that are not in 'customData'
    newJob.customSeqName="010"
    newJob.customShotName="189"
    newJob.customVersionName="B4"
    newJob.customSceneName="beautyrender" #replaces scene filename in rrControl table
    newJob.customJobType="Playblast"
    newJob.division="Playblast;Maya"


    newJob.renderApp= renderApp
    logger.debug("Adding Job:  {}-{}   ".format(renderApp.name, newJob.renderApp.rendererName))
    rrSubmitter.addJob(newJob)


    
if (exportAsXML):
    now = datetime.now() 
    xmlFilename= os.path.join(tempfile.gettempdir(), "rrPythonScript"+ "_"+ now.strftime("%m%d%H%M%S") +".xml")
    
    rrJob.exportJobAsXml_MultiStart()
    for jNr in range(0, rrSubmitter.getJobCount()):
        job= rrSubmitter.getJob(jNr)
        rrJob.exportJobAsXml_MultiAdd(job, False)
    if not rrJob.exportJobAsXml_MultiEnd(xmlFilename, False, False):
        logger.error("Unable to export as xml file "+xmlFilename)
    else:
        logger.info("Exported as xml file "+xmlFilename)

else:
                
    if (not rrSubmitter.submitJobs()):
        logger.error("Unable to submit jobs!")
    else:
        rrJobIDs_All_Str=""
        rrJobID_LIST= []
        rrJobIDStr_LIST= []
        for jNr in range(0, rrSubmitter.getJobCount()):
            rrJobID_LIST.append(rrSubmitter.jobsSendID(jNr))
            rrJobIDStr_LIST.append(rrJob.jID2Str(rrJobID_LIST[jNr]))
            rrJobIDs_All_Str= rrJobIDs_All_Str + rrJob.jID2Str(rrJobID_LIST[jNr]) + ", "
        logger.info("Submited {} jobs: {}".format(len(rrJobID_LIST),rrJobIDs_All_Str ))




