import  reporter
import datetime


#Read the start and end day from the report config:
reportTime_StartDay = rrReportTime.startDay()
reportTime_StartWeekDay = rrReportTime.startWeekDay()
reportTime_EndDay = rrReportTime.endDay()
reportTime_DayCount = reportTime_EndDay- reportTime_StartDay +1

#if set to "last week"
#reportTime_Infostring="\n {} - {}".format(rrReportTime.startTime_datetime().strftime('CW%W  %d.%b.%Y'), rrReportTime.endTime_datetime().strftime('%d.%b.%Y'))
#if set to "last month"
reportTime_Infostring="\n {} - {}".format(rrReportTime.startTime_datetime().strftime('%B  %d.%b.%Y'), rrReportTime.endTime_datetime().strftime('%d.%b.%Y'))



#-------------------------------------------------------------------------------------
#Some error checking first
#Please delete the classes you do not use in your report

#rrJobLoader
err = rrJobLoader.getError() #e.g. unable to load, stats folder not found, ...
if err != "":
    raise Exception("rrJobLoader Precheck: " + err) 


#rrDailyStats
err = rrDailyStats.getError() 
if err != "":
    raise Exception("rrDailyStats Precheck: " + err) 

    
if myCompanyProject == "":    
    raise Exception("No myCompanyProject set. ") 

    
    
rrGlobal.progress_SetInfo("Loading history DB...")    
    
#-------------------------------------------------------------------------------------
print("------ rrJobLoader list of projects: --------")
print("Project count history DB: "+str(rrJobLoader.projectCount()))
for pIdx in range(0, rrJobLoader.projectCount()):
    print("       #" + str(pIdx) + ": "+ rrJobLoader.projectName(pIdx))

rrGlobal.progress_SetInfo("Retrieve rrServer queue...")    

# rrJobLoader loads the project list from the history database by default in the RealmReporter
# now we add  projects that might be in the current queue but not yet in the History DB.
if not rrJobLoader.queue_AddProjectList():
    raise Exception("Unable to retrieve project list from rrServer: "+ rrJobLoader.getError()) 

print("Project count history DB + rrServer: "+str(rrJobLoader.projectCount()))
for pIdx in range(0, rrJobLoader.projectCount()):
    print("       #" + str(pIdx) + ": "+ rrJobLoader.projectName(pIdx))



#Some charts require jobs that have been submitted in our time range, some charts require jobs that finished in our reports time range.
#So we include both and filter again within each chart later
rrJobLoader.period_setTimeMode(3)


rrJobLoader.setProject(myCompanyProject)

if not rrJobLoader.history_LoadJobs():
    raise Exception("Unable to set load history DB of project " + myCompanyProject + ":  "+ rrJobLoader.getError()) 
    
print("History load info: "+ str(rrJobLoader.getInfo()))
print("Number of History DB jobs loaded: "+ str(rrJobLoader.jobCount()))

if not rrJobLoader.queue_AddJobs():
    raise Exception("Unable to load jobs from rrServer for project "+myCompanyProject + ":  "+ rrJobLoader.getError()) 

print("Number of history+rrServer jobs loaded: "+ str(rrJobLoader.jobCount()))


rrGlobal.progress_SetInfo("Generating charts...")
#***************************** Text Header *****************************
#      
Header.setLabel("Project " + myCompanyProject + reportTime_Infostring )



#***************************** Table TableSummary *****************************
#   
apps_PS= {}
apps_Watt= {}
apps_Cost= {}
apps_time= {}
apps_frames= {}


for j in range(0, rrJobLoader.jobCount()):
    job =  rrJobLoader.jobAt(j)
    #we do not want jobs that have been submitted in our time range, but did not finish in our report time range
    if (job.dateFinished==0 or job.dateFinished > rrReportTime.endTime_datetime()):
        continue
    if not job.soft.name in apps_PS:
        apps_PS[job.soft.name] = 0
        apps_Watt[job.soft.name] = 0
        apps_Cost[job.soft.name] = 0
        apps_time[job.soft.name] = 0
        apps_frames[job.soft.name] = 0
    apps_PS[job.soft.name] = apps_PS[job.soft.name] + job.infoRenderTimeSum_PS_disobeyReset
    apps_Watt[job.soft.name] = apps_Watt[job.soft.name] + job.infoRenderTimeSum_WattSec_disobeyReset
    apps_Cost[job.soft.name] = apps_Cost[job.soft.name] + job.infoRenderTime_Cost_PS_disobeyReset
    apps_time[job.soft.name] = apps_time[job.soft.name] + job.infoRenderTimeSum_seconds_disobeyReset
    apps_frames[job.soft.name] = apps_frames[job.soft.name] + job.infoTotal_FramesReturned_disobeyReset
    

TableSummary.setRowName(0, "Total kPS*sec")
TableSummary.setRowName(1, "Total Time (if one machine used)")
TableSummary.setRowName(2, "Frames rendered")
TableSummary.setRowName(3, "Cost")
TableSummary.setRowName(4, "KWh")

col=-1
total_PS= 0
total_Watt= 0
total_Cost= 0
total_time= 0
total_frames= 0

for appName in apps_PS.keys():
    apps_Watt[appName]= int(apps_Watt[appName] //60//60)
    apps_PS[appName]=apps_PS[appName] // 1000
    apps_frames[appName]= int(apps_frames[appName])
    apps_Cost[appName]= int(apps_Cost[appName])

    col= col+1
    TableSummary.setColName(col, appName)
    TableSummary.setCell(col, 0, str(apps_PS[appName]))
    TableSummary.setCell(col, 1, str(reporter.rrTextTimespan(apps_time[appName])))
    TableSummary.setCell(col, 2, str(reporter.rrTextTsdSpace(apps_frames[appName])))
    TableSummary.setCell(col, 3, str(reporter.rrTextTsdSpace(apps_Cost[appName])))
    TableSummary.setCell(col, 4, str(reporter.rrTextTsdSpace(apps_Watt[appName])))
    
    total_PS= total_PS+apps_PS[appName]
    total_Watt= total_Watt+apps_time[appName]
    total_Cost= total_Cost+apps_frames[appName]
    total_time= total_time+apps_Cost[appName]
    total_frames= total_frames+apps_Watt[appName]

col= col+1
TableSummary.setColName(col, "Total")

TableSummary.setCell(col, 0, str(total_PS))
TableSummary.setCell(col, 1, str(reporter.rrTextTimespan(total_time)))
TableSummary.setCell(col, 2, str(reporter.rrTextTsdSpace(total_frames)))
TableSummary.setCell(col, 3, str(reporter.rrTextTsdSpace(total_Cost)))
TableSummary.setCell(col, 4, str(reporter.rrTextTsdSpace(total_Watt)))


#***************************** PieCharts *****************************
#   


apps= {}
apps2= {}
for j in range(0, rrJobLoader.jobCount()):
    job =  rrJobLoader.jobAt(j)
    #we do not want jobs that have been submitted in our time range, but did not finish in our report time range
    if (job.dateFinished==0 or job.dateFinished > rrReportTime.endTime_datetime()):
        continue
    if not job.soft.name in apps:
        apps[job.soft.name] = 0
        apps2[job.soft.name] = 0
    apps[job.soft.name] = apps[job.soft.name] + job.infoTotal_FramesReturned_disobeyReset
    apps2[job.soft.name] = apps2[job.soft.name] + job.infoRenderTimeSum_PS_disobeyReset
    

for appName in apps.keys():
    PieFrames.addSlice(apps[appName], appName)
    PiePSUsage.addSlice(apps2[appName], appName)


#***************************** LineChart LineJobSubmittedPerApp *****************************
#   Jobs submitted (as framecount)
#
#************************************    LineChart LineJobSubmittedPerApp    ************************************

#time steps in hours
timePrecision=3
if (reportTime_DayCount<=2):
    timePrecision=1
elif (reportTime_DayCount>7):
    timePrecision=6
elif (reportTime_DayCount>15):
    timePrecision=24
timePrecision= timePrecision *60 *60 #convert to seconds

for j in range(0, rrJobLoader.jobCount()):
    job =  rrJobLoader.jobAt(j)
    #we do not want jobs that have been submitted before our report time
    if (job.dateSend < rrReportTime.startTime_datetime()):
        continue
    lIdx=  LineJobSubmittedPerApp.findLineName( job.soft.name, True)
    LineJobSubmittedPerApp.addPointAtTime(lIdx, job.dateSend.timestamp(), timePrecision , job.framesTotal_FrameSetOnly );
    
    
#now we have to add data points at the times no job was submitted
#Otherwise we would not see that no job was submitted, the line would be drawn from one submission to the next
#index -1 changes all lines
LineJobSubmittedPerApp.fillTimeRange(-1, timePrecision)



#***************************** BarChart BarJobCountPerApp *****************************
#   Jobs Submitted/Completed (as framecount)
#
#************************************    BarChart BarJobCountPerApp    ************************************

apps= {}
for j in range(0, rrJobLoader.jobCount()):
    job =  rrJobLoader.jobAt(j)
    #we do not want jobs that have been submitted before our report time
    if (job.dateSend < rrReportTime.startTime_datetime()):
        #print("False " + str(job.dateSend)+"  "+  str(rrReportTime.startTime_datetime()))
        continue
    #print("True " + str(job.dateSend)+"  "+  str(rrReportTime.startTime_datetime()))
    if not job.soft.name in apps:
        apps[job.soft.name] = 0
    apps[job.soft.name] = apps[job.soft.name] + job.framesTotal_FrameSetOnly
   

sIdx= BarJobCountPerApp.addSection("Submitted")   
for appName in apps.keys():
    bIdx=  BarJobCountPerApp.addBarName(appName)
    BarJobCountPerApp.setValue(bIdx, sIdx, apps[appName])
    

apps= {}
apps2= {}
for j in range(0, rrJobLoader.jobCount()):
    job =  rrJobLoader.jobAt(j)
    #we do not want jobs that have been submitted in our time range, but did not finish in our report time range
    if (job.dateFinished==0 or job.dateFinished > rrReportTime.endTime_datetime()):
        continue
    if not job.soft.name in apps:
        apps[job.soft.name] = 0
        apps2[job.soft.name] = 0
    apps[job.soft.name] = apps[job.soft.name] + job.infoTotal_FramesReturned_disobeyReset
    apps2[job.soft.name] = apps2[job.soft.name] + job.framesTotal_FrameSetOnly
   

sIdx= BarJobCountPerApp.addSection("Finished (with re-rendered frames)")   
for appName in apps.keys():
    bIdx=  BarJobCountPerApp.findBarName(appName, True)
    BarJobCountPerApp.setValue(bIdx, sIdx, apps[appName])    

sIdx= BarJobCountPerApp.addSection("Finished")   
for appName in apps2.keys():
    bIdx=  BarJobCountPerApp.findBarName(appName, True)
    BarJobCountPerApp.setValue(bIdx, sIdx, apps2[appName])    
    

#***************************** BarChart BarFrameTimePSPerApp *****************************
#   Finished jobs - Computation time per frame
#
#************************************    BarChart BarFrameTimePSPerApp    ************************************

   
apps= {}
appsCount= {}
for j in range(0, rrJobLoader.jobCount()):
    job =  rrJobLoader.jobAt(j)
    #we do not want jobs that have been submitted before our report time
    if (job.dateSend < rrReportTime.startTime_datetime()):
        #print("False " + str(job.dateSend)+"  "+  str(rrReportTime.startTime_datetime()))
        continue
    #print("True " + str(job.dateSend)+"  "+  str(rrReportTime.startTime_datetime()))
    if (job.infoTotal_FramesReturned_disobeyReset>0):
        if not job.soft.name in apps:
            apps[job.soft.name] = 0
            appsCount[job.soft.name] = 0
        apps[job.soft.name] = apps[job.soft.name] + (job.infoRenderTimeSum_PS_disobeyReset/ job.infoTotal_FramesReturned_disobeyReset)
        appsCount[job.soft.name] = appsCount[job.soft.name] + 1


sIdx= BarFrameTimePSPerApp.addSection("Frame time in kPS*sec")   
for appName in apps.keys():
    apps[appName] = apps[appName] / appsCount[appName] / 1000
    bIdx=  BarFrameTimePSPerApp.addBarName(appName)
    BarFrameTimePSPerApp.setValue(bIdx, sIdx, apps[appName])

#***************************** BarChart BarFrameTimePerApp *****************************
#   Finished jobs - Time per frame
#
#************************************    BarChart BarFrameTimePerApp    ************************************

   

apps= {}
appsCount= {}
for j in range(0, rrJobLoader.jobCount()):
    job =  rrJobLoader.jobAt(j)
    #we do not want jobs that have been submitted before our report time
    if (job.dateSend < rrReportTime.startTime_datetime()):
        #print("False " + str(job.dateSend)+"  "+  str(rrReportTime.startTime_datetime()))
        continue
    #print("True " + str(job.dateSend)+"  "+  str(rrReportTime.startTime_datetime()))
    if (job.infoTotal_FramesReturned_disobeyReset>0):
        if not job.soft.name in apps:
            apps[job.soft.name] = 0
            appsCount[job.soft.name] = 0
        apps[job.soft.name] = apps[job.soft.name] + job.infoRenderTimeSum_seconds_disobeyReset/ job.infoTotal_FramesReturned_disobeyReset
        appsCount[job.soft.name] = appsCount[job.soft.name] + 1



sIdx= BarFrameTimePerApp.addSection("Frame time")   
for appName in apps.keys():
    apps[appName] = apps[appName] / appsCount[appName]
    bIdx=  BarFrameTimePerApp.addBarName(appName)
    BarFrameTimePerApp.setValue(bIdx, sIdx, apps[appName])

#***************************** LineChart  *****************************
#


#time steps in hours
timePrecisionHour=1
if (reportTime_DayCount>7):
    timePrecisionHour=3
elif (reportTime_DayCount>15):
    timePrecisionHour=24
timePrecisionSec= timePrecisionHour *60 *60 #convert to seconds


for dayIdx in range(reportTime_StartDay, reportTime_EndDay+1):
    if not rrDailyStats.period_day_hasData(dayIdx):
        continue
    statPrj= rrDailyStats.period_day(dayIdx).getJobsByTypeAndName(2, myCompanyProject)
    if (statPrj.name == ""):
        #getJobsByTypeAndName returned an empty project as myCompanyProject does not exist that day
        continue
    
    dataFrames = [0 for y in range(24)] 
    dataIdle = [0 for y in range(24)] 
    dataMem = [0 for y in range(24)] 
    dataPS = [0 for y in range(24)] 
    dataCount = [0 for y in range(24)] 
    
    sph= statPrj.timeSlotCount()//24  #slots per hour 
    sph= sph* timePrecisionHour #slots per our precision 
    maxPerDay= 24 // timePrecisionHour #how many data points do we collect this day
    
    for sIdx in range(0, statPrj.timeSlotCount()):
        slot= statPrj.getTimeSlot(sIdx)
        if not slot.hasValidData():
            continue
        hour= sIdx // sph
        dataFrames[hour]= dataFrames[hour] + slot.framesRendered
        dataIdle[hour]= dataIdle[hour] + slot.jobsIdle
        dataPS[hour]= dataPS[hour] + slot.avPSUsage
        dataCount[hour]= dataCount[hour] + 1
        if (dataMem[hour] < slot.maxMemUsageMB):
            dataMem[hour] = slot.maxMemUsageMB
             
    
    for hour in range(0, maxPerDay):
        if dataCount[hour]>0:
            #average the data
            dataIdle[hour] = dataIdle[hour] / dataCount[hour]
            dataPS[hour] = dataPS[hour] / dataCount[hour]
            dataMem[hour] = dataMem[hour] /1024
            
            #print(str(dataMem[hour]))
            #time of this data point:
            dataTime= int(rrReportTime.startTime_datetime().timestamp()) #startTime as Unix UTC
            dataTime= dataTime + (dayIdx - reportTime_StartDay)* 24 * 60 * 60 #add the date of the day loop
            dataTime= dataTime + (hour * timePrecisionSec)
            
            #print(dataTime)
            LineFramesRendered.addPointAtTime(0, dataTime, 1, dataFrames[hour] );
            LineJobsIdle.addPointAtTime(0, dataTime, 1, dataIdle[hour] );
            LineMemUsage.addPointAtTime(0, dataTime, 1, dataMem[hour] );
            LineClientUsage.addPointAtTime(0, dataTime, 1, dataPS[hour] );
    
    
LineFramesRendered.setLineName(0,"Frames")
LineJobsIdle.setLineName(0,"Jobs")
LineMemUsage.setLineName(0,"GiB")
LineClientUsage.setLineName(0,"PS")
    
    
#now we have to add data points at the times we did not had any information
#Otherwise the line would be drawn from one data point to the next, but it should be 0 in that time
#index of -1 changes all lines
LineFramesRendered.fillTimeRange(-1, timePrecisionSec)
LineJobsIdle.fillTimeRange(-1, timePrecisionSec)
LineMemUsage.fillTimeRange(-1, timePrecisionSec)
LineClientUsage.fillTimeRange(-1, timePrecisionSec)

   