#
#  This example 
#  gets a list of jobs of a user
#  and changes some settings of the job
#
#

import os
import sys
import random
random.seed()

mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)

from rr_python_utils.load_rrlib import rrLib  # module libpyRR3 for python 3, libpyRR2 for python 2
import rr_python_utils.connection as rr_connect
import rrJob


def connectToServer():
    print("Connecting to rrServer by using a convenience function...")
    tcp = rr_connect.server_connect()
    return tcp
    


def get_user_jobs(tcp, job_user_name=""):
    ### How does it work?
    ### Think about it the same way rrControl works
    ### a) In rrControl you set the filter (Project, user, finished, rendering)
    ### b) Then rrControl/you pressed the update button in the upper right to retrieve the jobs
    ### c) rrControl has now your list of jobs matching the filter.
    ###    and rrControl has a list of all jobs in the queue. (You notice that if you change the filter, but rrControl cannot show job data like scene name)

    print("Getting a list of jobs...")
    tcp.jobList_SetFilter3(job_user_name, "", "", 0, "", False, rrLib._filterIDs.isAll)
    jobs_list = []

    if not tcp.jobList_GetBasic():
        print("Error jobList_GetBasic: " + tcp.errorMessage())
        return jobs_list

    jobs_count = tcp.jobs.getMaxJobsFiltered()
    if jobs_count == 0:
        print("No jobs of user '{0}'".format(job_user_name))
        return jobs_list

    for i in range(jobs_count):
        job_id = tcp.jobs.getJobMinInfo_filterQueue(i).ID
        jobs_list.append(job_id)
    return jobs_list



tcp= connectToServer()

jobs_list=[]
#get all jobs of user renderfarm:
jobs_list=get_user_jobs(tcp, "renderfarm")

#As you can change multiple jobs at once, you require the 'SettingsOnly' class 2x times
#1) One instance that contains the settings
#2) The other class to tell RR which settings to apply for all jobs
#   Any setting set to anything other than zero/empty will be applied
settings_Value=      rrJob.getClass_SettingsOnly()
settings_ChangeFlag= rrJob.getClass_SettingsOnly()

settings_Value.seqStart=random.randint(2,50)
settings_Value.seqEnd=random.randint(80,120)
settings_Value.rrParam_Set(rrJob._RRParams.rrpRequiredMemoryGB, 95)
settings_Value.division= "Turntables"


#any value other than 0
settings_ChangeFlag.seqStart=1
settings_ChangeFlag.seqEnd=1    
settings_ChangeFlag.rrParam_Set(rrJob._RRParams.rrpRequiredMemoryGB, 1) 
#any value other than an empty string
settings_ChangeFlag.division="sdfdfsdfsdfsdfd"   




if len(jobs_list) != 0:
    print("Changing jobs...")
    if not tcp.jobModify(jobs_list, settings_Value, settings_ChangeFlag):
        print("Error jobModify: " + tcp.errorMessage())



print("\n\n--- DONE ---\n\n")
