# Royal Render plugin
#
# Information: RR reads the first comment block to get the settings for this plugin.
#
# These lines are just information lines for you and have no effect.  They are *not* required
# rrPluginName:		Hello Event
# rrPluginAuthor:	Holger Schoenberger
# rrPluginVersion:	1.0
# rrPluginType:		Job Event Plugin
# rrRRversion:		8.2.00
#
#
# Your finished script has to be copied into the folder [RR]\plugins64\server_events\
#
#
# These settings are important for server event plugins and have to be set.
# They tell the rrServer when this plugin should be executed. 
# A "1" or "true" activates the plugin for this execution step. Everything else disables it.
# 
#
#
# ____________________________ ERROR EVENTS TO HANDLE: ____________________________
#
# eCrashed:                       
# eOutputdirNotFound:             1
# eNoFreeSpaceLeft:               0
# eFileserverTimeDifference:    
# eNoFrameRendered:             
# eSeqDivAdjusted:              
# eToManyCrashes:              true 
# eSceneNotFound:               
# eRenderAppNotFound:           
# eExecuteError:
# eClientNoLocalDriveSpaceLeft:
# eUNCMapFailed:
# eNoRenderLicense:
# eClientRenderCrashed:
# eSendToOften:
# eClientLowSysMem:    
# eClientRenderCrashedPermanently: 
# eClientRenderFroze: 
# eRenderAppWrongVersion: 
# eClientNoRenderTimeIssue:
# eDoublePostExecution: 
# eAbortFrameTime: 
# eClientFoundLogError: 
# eToManyLimitsReached: 
# eCrashedKSOLogError: 
# eOutputdirNotFound_CacheServer: 
#        
#        
# ____________________________ LOG EVENTS TO HANDLE: ____________________________
#      
# lAbortedReservedClients:
# lEnable:                      0
# lDisable:                     1
# lDisableAbort:                1
# lApproveMain:
# lDisApproveMain:
# lDelete:
# lAbort:
# lCheck:
# lReset:
# lResetNDelete:                true
# lChangeClientAssignment:
# lJobSubmitted: 
# lAllFramesDone:
# lJobFinished:             true

# lClientRenderSuccessful:
# lClientRenderSuccessfulNoFrames:
# lClientRenderAborted:
# lClientRenderAbortedLowMem:
# lClientRenderAbortedFrozen:
# lClientRenderError:
# lClientRenderAbortedHighCpu:
# lClientRenderAbortedWorkinghours:
# lClientRenderAbortedProcessFound:
# lClientRenderAbortedReservedClient:
# lClientRenderAbortedHighPriorityJob:
# lClientRenderAbortedrrControl:
# lClientRenderAbortedAveraging:
# lClientRenderAbortedLicenseBlock:
# lClientRenderAbortedLocalMachine:
# lClientRenderAbortedDisabled:

# lAutoDeleteAfterDays:
# lFramesDeleted:
# lAllFramesAssigned:
# lSeqDivAdjusted:
# lReceiveJob:
# lChangeSettings:
# lDeleteFinished:
# lDeleteDisabled:
# lClearErrormessages:
# lmarkFinished:
# lDeassignClients:
# lEmitChange:
# lAbortedFrameTime:
# lAbortLowPriority:
# lClientSegmentLessThanXs:
# lClearErrormessagesEnable:
# lFirstCheck:

# lDisableManyCrashes: true
# lDisableNoFrames:
# lDisableNoOutputDir:
# lDisableUNCFailed:
# lDisableNoDriveSpace:
# lDisableManyLimitsReached:
# lDisable3TimesMoreSend:

# lClientAssignmentLost:
# lClientAssignmentWrong:
# lClientKSOClose:
# lChangeSettingsSequence:
# lWaitForFinished:
# lAutoDeleteMaxReached:
# lCrashedKSOLogError:
# lSetStatePostRenderScript:
# lSetStateFinishedScript:
# lReassignDeassigned:
# lClientRenderSuccessfulNoFrames:
# lFrameSendTooManyTimes:
# lDisable3TimesMoreSend:
# lStatusChange:
# lStatusChangeRequest:
# lSetParentjobFrameSet:
# lApproveCloud:
# lDisApproveCloud:
# lApprovePreview:
# lDisApprovePreview:
# lApproveCustom:
# lDisApproveCustom:
# lIgnoreWaitFor:
# lSetCustomVariables:
# lChangeCommentInfo:




#-----------------------------------------------------------------------------------------------

rrGlobal.writeLog2(rrGlobal.logLvL.info,  "***************************** My Event Plugin *****************************")


#Get the job that triggered this/these event(s):
job= rrEvent.getJob()
rrGlobal.writeLog2(rrGlobal.logLvL.info,  "Example Python script:\n I am job " + job.sceneName)
rrGlobal.writeLog2(rrGlobal.logLvL.info,  "My status is: " + job.statusAsString())
rrGlobal.writeLog2(rrGlobal.logLvL.info,  "My custom data 'Test' is: "+ job.customData_Str("Test"))
rrGlobal.writeLog2(rrGlobal.logLvL.info,  "All my custom data is: "+ job.customData_AllAsString())
IDmain= job.IDmain()
IDcomplete= job.ID
IDstr= job.IDstr
rrGlobal.writeLog2(rrGlobal.logLvL.info,  "Event Plugin: This job "+str(IDstr)+" "+str(IDcomplete)+" has the main ID: "+str(IDmain))
    
    
    
#Log all event that triggered this script:
rrGlobal.writeLog2(rrGlobal.logLvL.info,  "Event Plugin: In the last ~45sec these job events have triggered this script: ")
rrGlobal.writeLog2(rrGlobal.logLvL.info,  rrEvent.allEvents())



#Log each event seperately, first the 'server job log events'
for i in range(rrEvent.logCount()):
    log_event = rrEvent.logItem(i)
    log_ID= log_event.what
    if (log_ID==rrJob._LogMessage.lDisApproveMain):
        rrGlobal.writeLog2(rrGlobal.logLvL.info, "Log Message lDisApproveMain  found: " + log_event.string())
    elif (log_ID==rrJob._LogMessage.lDisable):
        rrGlobal.writeLog2(rrGlobal.logLvL.info, "Log Message lDisable  found: " + log_event.string())
    elif (log_ID==rrJob._LogMessage.lDisableAbort):
        rrGlobal.writeLog2(rrGlobal.logLvL.info, "Log Message lDisableAbort  found: " + log_event.string())
    else:
        rrGlobal.writeLog2(rrGlobal.logLvL.info, "Log Message - any other with ID {}. Name: {}".format(log_ID, log_event.string()) )
        
        
#Log each event seperately, now the 'Job error events'        
for i in range(rrEvent.errCount()):
    log_event = rrEvent.errItem(i)
    log_ID= log_event.what
    if (log_ID==rrJob._ErrorMessage.eSendToOften):
        rrGlobal.writeLog2(rrGlobal.logLvL.info, "Log Message eSendToOften  found: " + log_event.string())
    elif (log_ID==rrJob._ErrorMessage.eTooManyCrashes):
        rrGlobal.writeLog2(rrGlobal.logLvL.info, "Log Message eTooManyCrashes  found: " + log_event.string())
    else:
        rrGlobal.writeLog2(rrGlobal.logLvL.info, "Log Message - any other: " + log_event.string())
                       



#In case we need to check ALL other jobs that are currently in the queue (might slow down your script depending on the number of jobs you have)

#In this case we try to find sibling jobs. Jobs that have been submitted with this jobs. The job ID starts with the same letters: {FFFFa} {FFFFb} {FFFFc}
rrGlobal.writeLog2(rrGlobal.logLvL.info,     "Event Plugin: List all jobs: ")
jobCount = rrEvent.jobAll_count()
jobSiblingList= []
for i in range(jobCount):
    selectedJob = rrEvent.jobAll_get(i)
    #This line would result in a huge log file: rrGlobal.writeLog2(rrGlobal.logLvL.info, "              "+selectedJob.IDstr())
    if (IDmain==selectedJob.IDmain()):
        jobSiblingList.append(selectedJob.ID)
    
rrGlobal.writeLog2(rrGlobal.logLvL.info,  "Event Plugin: Found " +str(len(jobSiblingList))+ " sibling jobs (including this job). Dis-approving these jobs now.")
rrEvent.jobSendCommand(jobSiblingList, rrJob._LogMessage.lDisApproveMain,0)    
    

#In case we need to check ALL rrClients  
rrGlobal.writeLog2(rrGlobal.logLvL.info,    "Event Plugin: List all clients: ")
nrClients= rrEvent.clientAll_count()
for ic in range(0, nrClients):
    loopClient= rrEvent.clientAll_get(ic)
    rrGlobal.writeLog2(rrGlobal.logLvL.info,"              "+loopClient.name()  )
    
rrGlobal.writeLog2(rrGlobal.logLvL.info,  "***************  My Event Plugin: Done **************")    
    















