$dstBlobName = "<myblobname>"
$dstStorageName = "<mystoragename>"
$dstStorageKey = "<mystoragekey>"

# no need to change script below this line
# source storage information
$srcStorageName = "royalrenderpublic"
$srcStorageKey = "Dek51eRQEWmE1S4KicOze+6GqkGvSEgmkT3NFZGkrZ5wIbItX6vwy9P9I+i4uZwt1QEmLCMcGMXvNo0+QfDDeA=="
$srcContainer = "images"
$srcBlobName = $dstBlobName 

$srcContext = New-AzureStorageContext -StorageAccountName $srcStorageName -StorageAccountKey $srcStorageKey
$dstContext = New-AzureStorageContext -StorageAccountName $dstStorageName -StorageAccountKey $dstStorageKey

$targetBlob = Start-AzureStorageBlobCopy -SrcContainer $srcContainer -SrcBlob $blobName `
        -DestContainer images -DestBlob $dstBlobName `
        -Context $srcContext -DestContext $dstContext
Write-Host "Copying blob $blobName"
$copyState = $targetBlob | Get-AzureStorageBlobCopyState

while ($copyState.Status -ne "Success")
{
  $percent = ($copyState.BytesCopied / $copyState.TotalBytes) * 100
  Write-Host "Completed $('{0:N2}' -f $percent)%"
  sleep -Seconds 20
  $copyState = $targetBlob | Get-AzureStorageBlobCopyState
}