# -*- coding: cp1252 -*-
overrideIcon= "V05__VideoEnhanceAI.png"

######################################################################
#
# Name:  Create AI scaled HQ version of input videos
# Author:  Royal Render, Holger Schoenberger, Binary Alchemy
# Version: 
# Description: 
#   This scripte creates an Topaz Video Enhancer AI job for each input video.
#
# Copyright (c) Holger Schoenberger - Binary Alchemy
######################################################################





#------------------------------- Create UI ---------------------------------------------------


myUI= rrGlobal.getGenericUI()
myUI.addItem(rrGlobal.genUIType.label,"infoLabel","")
myUI.setText("infoLabel","Please paste the commandline:")
myUI.addItem(rrGlobal.genUIType.lineEdit,"commandline","")

myUI.addItem(rrGlobal.genUIType.label,"labelD","")
myUI.setText("labelD","Optional:\nProcess all videos in folder:")
myUI.addItem(rrGlobal.genUIType.browseDir,"sourceD","")



myUI.addItem(rrGlobal.genUIType.layoutH,"btnLayout","")
myUI.addItem(rrGlobal.genUIType.closeButton,"Create Job(s)","btnLayout")
myUI.addItem(rrGlobal.genUIType.closeButton,"Abort","btnLayout")


#------------------------------- Execute UI ---------------------------------------------------

myUI.execute()
if (myUI.value("Abort")==1):
    del myUI
    raise rrCleanExit()
    
isDirMode=False
sourceDir=myUI.text("sourceD");
if (len(sourceDir)>0):
    isDirMode=True
    
commandline=myUI.text("commandline")
del myUI


commandline = commandline.replace('"-hide_banner"', '')
commandline = commandline.replace('"-nostdin"', '')
commandline = commandline.replace('"-y"', '')
commandline = commandline.replace('"-nostats"', '')
commandline = commandline.replace('ffmpeg ', '')
#commandline = commandline.replace('"-hwaccel" "auto"', '')
 

sPos=commandline.find('"-i"')
commandline= commandline[:sPos] + commandline[sPos+5:]
firstQuot=-1
secondQuot=-1
for p in range(sPos,len(commandline)):
    if commandline[p]=='"':
        if (firstQuot==-1):
            firstQuot=p
        else:
            secondQuot=p+1
            break
            
sourceFile=commandline[firstQuot+1:secondQuot-1]
commandline= commandline[:firstQuot] + commandline[secondQuot:]


firstQuot=-1
secondQuot=-1
for p in range(len(commandline)-1,1, -1):
    if commandline[p]=='"':
        if (secondQuot==-1):
            secondQuot=p
        else:
            firstQuot=p+1
            break


OutFile=commandline[firstQuot:secondQuot]
commandline= commandline[:firstQuot-2]
commandline = commandline.strip()


#------------------------------- create video file list ---------------------------------------------------
from pymediainfo import MediaInfo
import os
import datetime



class resData:
    def __init__(self):
        self.y = 0
        self.x = 0 
        self.filename=""
        self.valid= False
        self.frameCount=1
    def getResolution(self,fileName):
        self.y = 0
        self.x = 0 
        self.frameCount=1
        self.filename=fileName
        media_info = MediaInfo.parse(fileName)
        for track in media_info.tracks:
            if track.track_type == "Video":
                if (track.height and track.width and track.frame_count):
                   self.x = int(track.width)
                   self.y = int(track.height)
                   self.frameCount = int(track.frame_count)
                   self.valid= True
                   #print(track.to_data())
                   #print("X: " + str(self.x) +"   Y: " + str(self.y) + "    Frames: "+str(track.frame_count))
                   
    
videoList= []
rrGlobal.progress_SetProgressA(0)
rrGlobal.progress_SetProgressB(0)
rrGlobal.progress_CancelHide()
rrGlobal.refreshUI()
 
vidCount=0

if (not isDirMode):
    resInfo= resData()
    resInfo.getResolution(sourceFile)  
    if (resInfo.valid):
        videoList.append(resInfo)
    rrGlobal.progress_SetMaxA(1)
    rrGlobal.progress_SetMaxB(1)
elif (os.path.isdir(sourceDir)):
    for file in os.listdir(sourceDir):
        vidCount= vidCount+1
    rrGlobal.progress_SetMaxA(vidCount)
    rrGlobal.progress_SetMaxB(vidCount)
    rrGlobal.progress_SetProgressB(0)
    vidCount=0
    
    for file in os.listdir(sourceDir):
        vidCount= vidCount+1
        rrGlobal.progress_SetProgressLabelA(vidCount,file )
        rrGlobal.refreshUI()
        if file.endswith(".avi") or file.endswith(".mpg") or file.endswith(".mpeg") or file.endswith(".mkv") or file.endswith(".wmv"):
            joinedName= os.path.join(sourceDir, file)
            #print(joinedName)
            resInfo= resData()
            resInfo.getResolution(joinedName)     
            if (resInfo.valid):
                videoList.append(resInfo)



#------------------------------- Create job(s) ---------------------------------------------------
renderApp= rrJob._RenderAppBasic()
renderApp.clear()
renderApp.name="VideoEnhanceAI"
renderApp.rendererName=""

vidCount=0

targetExt= OutFile[OutFile.rfind('.'):]




for video in videoList:
    vidCount= vidCount+1
    rrGlobal.progress_SetProgressB(vidCount)
    rrGlobal.refreshUI()
    
    source= video.filename
    sourceFile= source[:source.rfind('.')]
    if (sourceFile.endswith(".")):
        sourceFile= sourceFile[:len(sourceFile)-1]
    if (source.rfind('/')>0):
        sourceDir= source[:source.rfind('/')+1]
    else:
        sourceDir= source[:source.rfind('\\')+1]
    sourceFile= sourceFile[len(sourceDir):]
    
    
    if (not isDirMode):
        targetName=OutFile
    else:
        targetName= sourceDir + "scaled/" +  sourceFile + targetExt

        
    newJob=  rr.getNewJob()
    newJob.renderApp= renderApp
    newJob.sceneName= source
    newJob.imageFramePadding= 6
    newJob.imageFileName= targetName
    #newJob.imageSingleOutputFile=True
    newJob.splitImageFileInto_DirFileExt(False)
    newJob.uiIsChecked= True
    newJob.seqStart= 0
    newJob.seqEnd= video.frameCount-1;
    
    newJob.customDataSet_Str("AddCmdFlags", commandline)
    newJob.customDataAppend_Str("rrSubmitterParameter", " RequiredMemory=1~6")
    newJob.customDataAppend_Str("rrSubmitterParameter", " MaxCrashes=1~2")

    rr.jobAll_set(999,newJob); 
                               
