# -*- coding: cp1252 -*-
#
# These lines are just information lines for the plugin loader
# rrPluginName:		Toon Boom HArmony Scene parser
# rrPluginAuthor:	Holger Schoenberger
# rrPluginVersion:	%rrVersion%
# rrPluginType:		Scene Parser Plugin
# rrRRversion:		8.0
#
#
#
# This setting is important for scene parser job plugins and need to be set.
# 
# rrSupportedFileExt: *.xstage;
#
#
#
# Copyright (c) Holger Schoenberger - Binary Alchemy
######################################################################
import os
import xml.etree.ElementTree


#get all global settings first
sceneFile= rr.sceneFileToLoad()
try:
    sceneXml = xml.etree.ElementTree.parse(sceneFile).getroot()
except Exception as e:
    rrGlobal.writeLog2(rrGlobal.logLvL.warning, "Error loading xml file: "+str(e)) #progress messages will only be shown in the small log window of the rrSubmitter, but do not show a dialog window. As we do not want two dialog windows, see next line
    rr.returnFromPlugin(rrGlobal.pluginReturn.fileFailedToOpen)  # this shows a general message window
    raise rrCleanExit() #I am using rrCleanExit because I do not want any traceback info
   

try:    
    versionNode = sceneXml.find(".//project")
    version=sceneXml.attrib["version"]
    version = str(int(version) / 100 )+"."+str(int(version)  % 100 )
    
except Exception as e:
    rrGlobal.writeLog2(rrGlobal.logLvL.warning, "Error parsing file (version info): "+str(e)) #progress messages will only be shown in the small log window of the rrSubmitter, but do not show a dialog window. As we do not want two dialog windows, see next line
    rr.returnFromPlugin(rrGlobal.pluginReturn.dataError)  # this shows a general message window
    raise rrCleanExit() #I am using rrCleanExit because I do not want any traceback info
    
    
try:    
    resolutionNode= sceneXml.find(".//options/resolution")
    size= resolutionNode.attrib["size"]
    size= size.split(",")
    sceneWidth=int(size[0])
    sceneHeight=int(size[0])
    
except Exception as e:
    rrGlobal.writeLog2(rrGlobal.logLvL.warning, "Error parsing file (resolution info): "+str(e)) #progress messages will only be shown in the small log window of the rrSubmitter, but do not show a dialog window. As we do not want two dialog windows, see next line
    rr.returnFromPlugin(rrGlobal.pluginReturn.dataError)  # this shows a general message window
    raise rrCleanExit() #I am using rrCleanExit because I do not want any traceback info
   
   
   
#Create a render app
renderApp= rrJob._RenderAppBasic()
renderApp.clear()
renderApp.name="Harmony"
renderApp.setVersionBoth(version)


try:    
    sceneList= sceneXml.findall(".//scenes/scene")
    for sceneNode in sceneList:
        layerName=sceneNode.attrib["name"]
        seqEnd=int(sceneNode.attrib["nbframes"])
        seqStart=1
        
        camNode= sceneNode.find("options/camera")
        if (camNode==None):
            cameraName= ""
        else:
            cameraName= camNode.attrib["val"]

        allNodes=""
        moduleList= sceneNode.findall("rootgroup/nodeslist/module")

        newJob=  rr.getNewJob()
        newJob.sceneName=sceneFile
        newJob.uiIsChecked= True
        newJob.renderApp=renderApp
        newJob.layer= layerName
        newJob.camera= cameraName
        newJob.width=sceneWidth
        newJob.height=sceneHeight
        newJob.imageFileName= ""

        
        for modNode in moduleList:
            modType=modNode.attrib["type"]
            if (modType.lower()=="write"):
                outputFileTHISnode=""
                startNode= modNode.find("attrs/start")
                seqStart= int(startNode.attrib["val"])
                movieNode= modNode.find("attrs/exportToMovie")
                isMovie= str(movieNode.attrib["val"]).lower()!="false"
                if (isMovie):
                    outNode= modNode.find("attrs/moviePath")
                    outputFileTHISnode= outNode.attrib["val"]+".mov"
                else:
                    outNode= modNode.find("attrs/drawingName")
                    outputFileTHISnode= outNode.attrib["val"]
                    outNode= modNode.find("attrs/drawingType")
                    ext=outNode.attrib["val"]
                    ext= ext.lower()
                    ext=ext.replace("dp3","")
                    ext=ext.replace("dp4","")
                    ext=ext.replace("_16","")
                    ext=ext.replace("1","")
                    ext=ext.replace("3","")
                    ext=ext.replace("4","")
                    outputFileTHISnode= outputFileTHISnode+"###."+ext
                outputFileTHISnode= outputFileTHISnode.replace("\\","/")
                if (len(outputFileTHISnode)>2):
                    if ((outputFileTHISnode!="/") and (outputFileTHISnode[1]!=":")):
                        outputFileTHISnode= "<SceneFolder>/"+outputFileTHISnode;
                if (len(newJob.imageFileName)>0):
                    #we want to have the last write node to be checked for finished frames, put the previous one in channels[]
                    newJob.channel_add(newJob.imageFileName,"")
                newJob.imageFileName= outputFileTHISnode
       
        newJob.splitImageFileInto_DirFileExt(False)
        newJob.seqStart=seqStart
        newJob.seqEnd=seqEnd
        newJob.customSet_Str("rrSubmitterParameter","AllowLocalSceneCopy=0~0")
        rr.jobAll_set(999,newJob)  #If the index of the job is larger than the number of jobs,a new job is added to the end of the job list. So I used 999.

    
except Exception as e:
    rrGlobal.writeLog2(rrGlobal.logLvL.warning, "Error parsing file (layer info): "+str(e)) #progress messages will only be shown in the small log window of the rrSubmitter, but do not show a dialog window. As we do not want two dialog windows, see next line
    rr.returnFromPlugin(rrGlobal.pluginReturn.dataError)  # this shows a general message window
    raise rrCleanExit() #I am using rrCleanExit because I do not want any traceback info
   
   
      
   
   
   

rr.returnFromPlugin(rrGlobal.pluginReturn.successful)