import datetime
import time
import sys
import os


mod_dir = os.path.dirname(__file__)
if mod_dir not in sys.path:
    sys.path.append(mod_dir)

from rr_python_utils.load_rrdata import rrData


SECONDS_PER_DAY = 24 * 60 * 60
MINUTES_PER_DAY = 24 * 60


def load_saved_stats():
    stats_file = rrData.getRRFolder_cfgStats() + "StatsRenderTime90.db"
    print("loading stat file " + stats_file)
    rrStatsRenderTime=rrData._StatsRenderTime()
    loading_success = rrStatsRenderTime.loadFile(stats_file)
    if not loading_success:
        print("Error loading stats" + rrStatsRenderTime.getError())
        return
    print("- Loaded -")
    return rrStatsRenderTime


def print_stats(rrStatsRenderTime):
    print("   ")
    print("Stats had been saved at: ",rrStatsRenderTime.lastSaved)
    print("Number of projects: ",rrStatsRenderTime.prjCount)
    for pIdx in range(0, rrStatsRenderTime.prjCount): 
        project = rrStatsRenderTime.getProject(pIdx) 
        name = project.name
        last_used = project.lastUsed
        print("Project '{}' last change: {}".format(name, last_used))
        print("\t Number of Render3D   layers: {}".format(project.layerCount(1)))
        print("\t Number of FileExport layers: {}".format(project.layerCount(2)))
        print("\t Number of Archive    layers: {}".format(project.layerCount(3)))
        print("\t Number of Comp       layers: {}".format(project.layerCount(4)))
        
        for lIdx in range(0, project.layerCount(1)): 
            layer= project.getLayer(1, lIdx)
            print("\t\t Render3D Layer '{}'".format(layer.name))
            print("\t\t Total number of this layer in history: {}".format(layer.jobsAdded))
            print("\t\t Number of data entries for this layer: {}".format(layer.count()))
            for dIdx in range(0, layer.count()): 
                print("\t\t\t Frame time in seconds: {}".format(layer.frameTime_sec(dIdx )))
        for lIdx in range(0, project.layerCount(3)): 
            layer= project.getLayer(3, lIdx)
            print("\t\t Archive Layer '{}'".format(layer.name))
            print("\t\t Total number of this layer in history: {}".format(layer.jobsAdded))
            print("\t\t Number of data entries for this layer: {}".format(layer.count()))
            for dIdx in range(0, layer.count()): 
                print("\t\t\t Frame time in seconds: {}".format(layer.frameTime_sec(dIdx )))
            
        
        
        

    print("   ")




rrStatsRenderTime = load_saved_stats()

if rrStatsRenderTime:
    print_stats(rrStatsRenderTime)
